/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.kgcore;

import com.kinggrid.encrypt.MD5;
import com.kinggrid.exception.KGErrorPwdException;
import com.kinggrid.kgcore.KGHttpUtils;
import com.kinggrid.kgcore.ParserKeySealData;
import com.kinggrid.kgcore.SealInformation;
import com.kinggrid.kgcore.enmu.KGQueryByEnum;
import com.kinggrid.kgcore.enmu.KGSealSourceEnum;
import com.kinggrid.kgcore.enmu.KGServerTypeEnum;
import java.io.IOException;
import java.util.List;

public class KGElectronicSeal {
    private KGSealSourceEnum sealSourceEnum;
    private String keyPath;
    private int sealIndex;
    private String sealPwd;
    private String url;
    private KGServerTypeEnum type;
    private String keySN;
    private String password;
    private boolean forceValidatePwd = false;
    private String signName;
    private int index = -1;
    private KGQueryByEnum queryBy = KGQueryByEnum.KEYSN;

    public KGElectronicSeal(String keyPath, int sealNumb, String sealPwd) {
        this.keyPath = keyPath;
        this.sealIndex = sealNumb;
        this.sealPwd = sealPwd;
        this.sealSourceEnum = KGSealSourceEnum.KEY;
    }

    public KGElectronicSeal(String url, KGServerTypeEnum type, String keySN, String password, String signName) {
        this.url = url;
        this.type = type;
        this.keySN = keySN;
        this.password = password;
        this.signName = signName;
        this.index = -1;
        this.sealSourceEnum = KGSealSourceEnum.SERVER;
    }

    public KGElectronicSeal(String url, KGServerTypeEnum type, String keySN, String password, int index) {
        if (index < 0) {
            throw new RuntimeException("\u5370\u7ae0\u5e8f\u53f7\u4e0d\u80fd\u5c0f\u4e8e0\uff1aindex=" + index);
        }
        this.url = url;
        this.type = type;
        this.keySN = keySN;
        this.password = password;
        this.index = index;
        this.sealSourceEnum = KGSealSourceEnum.SERVER;
    }

    public SealInformation getSeal() throws IOException {
        SealInformation sealInformation = null;
        sealInformation = this.sealSourceEnum == KGSealSourceEnum.KEY ? this.getSealfromKey() : this.getSealfromServer();
        return sealInformation;
    }

    private SealInformation getSealfromKey() throws IOException {
        ParserKeySealData parserSealData = new ParserKeySealData();
        parserSealData.parserKeyFileData(this.keyPath);
        return parserSealData.getSealByIndex(this.sealIndex, this.sealPwd);
    }

    private SealInformation getSealfromServer() {
        KGHttpUtils http = new KGHttpUtils();
        http.setQueryBy(this.queryBy);
        List<SealInformation> seals = http.getServerSeal(this.url, this.type, this.keySN, null);
        if (this.index > -1) {
            if (this.index >= seals.size()) {
                throw new RuntimeException("\u8be5\u7528\u6237\u3010keySN=" + this.keySN + "\u3011\u53ea\u6709" + seals.size() + "\u4e2a\u5370\u7ae0\uff0c\u5f53\u524d\u5e8f\u53f7\uff08index\uff09\u503c\uff1a" + this.index);
            }
            SealInformation seal = seals.get(this.index);
            this.validatePwd(seal);
            return seal;
        }
        if (seals != null && seals.size() > 0) {
            for (SealInformation seal : seals) {
                String imgSignName = seal.getImgSignName();
                if (imgSignName == null || !imgSignName.equals(this.signName)) continue;
                this.validatePwd(seal);
                return seal;
            }
            throw new IllegalArgumentException(String.valueOf(this.keySN) + "\u7528\u6237\u6ca1\u6709\u540d\u79f0\u4e3a\u3010" + this.signName + "\u3011\u7684\u5370\u7ae0.");
        }
        throw new IllegalArgumentException(String.valueOf(this.keySN) + "\u7528\u6237\u6ca1\u6709\u53ef\u7528\u7684\u5370\u7ae0.");
    }

    private void validatePwd(SealInformation seal) {
        if (this.type == KGServerTypeEnum.CA0 || this.forceValidatePwd) {
            String pwd = MD5.stringToMD5(this.password, "UTF-8");
            if (!seal.getKeyPwd().equals(pwd)) {
                throw new KGErrorPwdException("\u7528\u6237\u3010" + this.keySN + "\u3011\u5bc6\u7801\u4e0d\u6b63\u786e.");
            }
        }
    }

    public boolean isSealFromServer() {
        return this.sealSourceEnum == KGSealSourceEnum.SERVER;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isForceValidatePwd() {
        return this.forceValidatePwd;
    }

    public void forceValidatePwd() {
        this.forceValidatePwd = true;
    }

    public KGQueryByEnum getQueryBy() {
        return this.queryBy;
    }

    public void setQueryBy(KGQueryByEnum queryBy) {
        this.queryBy = queryBy;
    }
}

