/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.img.seal;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class SquarepictureCreator {
    private int imageWidth = 100;
    private int imageHigth = 105;
    private String text;
    private Font textFont = new Font("\u5b8b\u4f53", 1, 40);
    private Color textColor = Color.red;
    private int cols = 2;
    private boolean vertical = true;
    private int border = 10;
    private int padding;
    private int rows;
    private char[][] charArray;

    public byte[] squarePng() throws IOException {
        if (this.text != "" && !"".equals(this.text)) {
            int j;
            int i;
            this.rows = (this.text.length() + this.cols - 1) / this.cols;
            this.charArray = new char[this.rows][this.cols];
            int n = 0;
            if (this.vertical) {
                i = 0;
                while (i < this.cols) {
                    j = 0;
                    while (j < this.rows) {
                        if (n < this.text.length()) {
                            this.charArray[j][i] = this.text.charAt(n);
                        }
                        ++n;
                        ++j;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.rows) {
                    j = 0;
                    while (j < this.cols) {
                        if (n < this.text.length()) {
                            this.charArray[i][j] = this.text.charAt(n);
                        }
                        ++n;
                        ++j;
                    }
                    ++i;
                }
            }
        }
        BufferedImage image = new BufferedImage(this.imageWidth, this.imageHigth, 1);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.textColor);
        g2.fillRect(0, 0, this.imageWidth, this.imageHigth);
        g2.setColor(Color.white);
        g2.fillRect(this.border, this.border, this.imageWidth - this.border * 2, this.imageHigth - this.border * 2);
        if (this.text != null && !"".equals(this.text)) {
            g2.setColor(this.textColor);
            g2.setFont(this.textFont);
            int i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.cols) {
                    int fontX = this.textFont.getSize() * j + this.padding + this.border;
                    int fontY = this.textFont.getSize() * i + this.textFont.getSize() + this.padding / 4 + this.border - this.textFont.getSize() / 40;
                    g2.drawString(String.valueOf(this.charArray[i][j]), fontX, fontY);
                    ++j;
                }
                ++i;
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHigth() {
        return this.imageHigth;
    }

    public void setImageHigth(int imageHigth) {
        this.imageHigth = imageHigth;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setText(String text, Font font) {
        this.text = text;
        this.textFont = font;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        SquarepictureCreator square = new SquarepictureCreator();
        square.setImageWidth(200);
        square.setImageHigth(210);
        square.setText("\u6c5f\u897f\u91d1\u683c", new Font("\u5b8b\u4f53", 1, 85));
        square.setTextColor(Color.red);
        square.setCols(2);
        square.setVertical(true);
        square.setBorder(10);
        square.setPadding(5);
        byte[] bs = square.squarePng();
        FileOutputStream file = new FileOutputStream(new File("F:/square.png"));
        file.write(bs);
    }
}

