/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.img;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class CutImage {
    private byte[] imageData;
    private String format;

    public CutImage(byte[] imageData, String format) {
        this.imageData = imageData;
        this.format = format;
    }

    public byte[] cut(int x, int y, int width, int height) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(this.imageData);
            byteArrayOutputStream = new ByteArrayOutputStream();
            Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName(this.format);
            ImageReader reader = it.next();
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            reader.setInput(imageInputStream, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rect = new Rectangle(x, y, width, height);
            param.setSourceRegion(rect);
            BufferedImage bi = reader.read(0, param);
            ImageIO.write((RenderedImage)bi, "png", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

