/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.xmp.impl;

public class Base64 {
    private static final byte INVALID = -1;
    private static final byte WHITESPACE = -2;
    private static final byte EQUAL = -3;
    private static byte[] base64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static byte[] ascii = new byte[255];

    static {
        int idx = 0;
        while (idx < 255) {
            Base64.ascii[idx] = -1;
            ++idx;
        }
        idx = 0;
        while (idx < base64.length) {
            Base64.ascii[Base64.base64[idx]] = (byte)idx;
            ++idx;
        }
        Base64.ascii[9] = -2;
        Base64.ascii[10] = -2;
        Base64.ascii[13] = -2;
        Base64.ascii[32] = -2;
        Base64.ascii[61] = -3;
    }

    public static final byte[] encode(byte[] src) {
        return Base64.encode(src, 0);
    }

    public static final byte[] encode(byte[] src, int lineFeed) {
        int bits6;
        int bits24;
        if ((lineFeed = lineFeed / 4 * 4) < 0) {
            lineFeed = 0;
        }
        int codeLength = (src.length + 2) / 3 * 4;
        if (lineFeed > 0) {
            codeLength += (codeLength - 1) / lineFeed;
        }
        byte[] dst = new byte[codeLength];
        int didx = 0;
        int sidx = 0;
        int lf = 0;
        while (sidx + 3 <= src.length) {
            bits24 = (src[sidx++] & 0xFF) << 16;
            bits24 |= (src[sidx++] & 0xFF) << 8;
            bits6 = ((bits24 |= (src[sidx++] & 0xFF) << 0) & 0xFC0000) >> 18;
            dst[didx++] = base64[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            dst[didx++] = base64[bits6];
            bits6 = (bits24 & 0xFC0) >> 6;
            dst[didx++] = base64[bits6];
            bits6 = bits24 & 0x3F;
            dst[didx++] = base64[bits6];
            if (didx >= codeLength || lineFeed <= 0 || (lf += 4) % lineFeed != 0) continue;
            dst[didx++] = 10;
        }
        if (src.length - sidx == 2) {
            bits24 = (src[sidx] & 0xFF) << 16;
            bits6 = ((bits24 |= (src[sidx + 1] & 0xFF) << 8) & 0xFC0000) >> 18;
            dst[didx++] = base64[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            dst[didx++] = base64[bits6];
            bits6 = (bits24 & 0xFC0) >> 6;
            dst[didx++] = base64[bits6];
            dst[didx++] = 61;
        } else if (src.length - sidx == 1) {
            bits24 = (src[sidx] & 0xFF) << 16;
            bits6 = (bits24 & 0xFC0000) >> 18;
            dst[didx++] = base64[bits6];
            bits6 = (bits24 & 0x3F000) >> 12;
            dst[didx++] = base64[bits6];
            dst[didx++] = 61;
            dst[didx++] = 61;
        }
        return dst;
    }

    public static final String encode(String src) {
        return new String(Base64.encode(src.getBytes()));
    }

    public static final byte[] decode(byte[] src) throws IllegalArgumentException {
        int srcLen = 0;
        int sidx = 0;
        while (sidx < src.length) {
            byte val = ascii[src[sidx]];
            if (val >= 0) {
                src[srcLen++] = val;
            } else if (val == -1) {
                throw new IllegalArgumentException("Invalid base 64 string");
            }
            ++sidx;
        }
        while (srcLen > 0 && src[srcLen - 1] == -3) {
            --srcLen;
        }
        byte[] dst = new byte[srcLen * 3 / 4];
        sidx = 0;
        int didx = 0;
        while (didx < dst.length - 2) {
            dst[didx] = (byte)(src[sidx] << 2 & 0xFF | src[sidx + 1] >>> 4 & 3);
            dst[didx + 1] = (byte)(src[sidx + 1] << 4 & 0xFF | src[sidx + 2] >>> 2 & 0xF);
            dst[didx + 2] = (byte)(src[sidx + 2] << 6 & 0xFF | src[sidx + 3] & 0x3F);
            sidx += 4;
            didx += 3;
        }
        if (didx < dst.length) {
            dst[didx] = (byte)(src[sidx] << 2 & 0xFF | src[sidx + 1] >>> 4 & 3);
        }
        if (++didx < dst.length) {
            dst[didx] = (byte)(src[sidx + 1] << 4 & 0xFF | src[sidx + 2] >>> 2 & 0xF);
        }
        return dst;
    }

    public static final String decode(String src) {
        return new String(Base64.decode(src.getBytes()));
    }
}

