/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.security;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.io.RASInputStream;
import com.KGitextpdf.text.io.RandomAccessSource;
import com.KGitextpdf.text.io.RandomAccessSourceFactory;
import com.KGitextpdf.text.io.StreamUtil;
import com.KGitextpdf.text.log.Logger;
import com.KGitextpdf.text.log.LoggerFactory;
import com.KGitextpdf.text.pdf.AcroFields;
import com.KGitextpdf.text.pdf.ByteBuffer;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDate;
import com.KGitextpdf.text.pdf.PdfDeveloperExtension;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfSignature;
import com.KGitextpdf.text.pdf.PdfSignatureAppearance;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.security.CrlClient;
import com.KGitextpdf.text.pdf.security.DigestAlgorithms;
import com.KGitextpdf.text.pdf.security.ExternalDigest;
import com.KGitextpdf.text.pdf.security.ExternalSignature;
import com.KGitextpdf.text.pdf.security.ExternalSignatureContainer;
import com.KGitextpdf.text.pdf.security.OcspClient;
import com.KGitextpdf.text.pdf.security.PdfPKCS7;
import com.KGitextpdf.text.pdf.security.TSAClient;
import com.kinggrid.pdf.DigitalSignatureByKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeSignature {
    private static final Logger LOGGER = LoggerFactory.getLogger(MakeSignature.class);

    public static void signDetached(PdfSignatureAppearance sap, ExternalDigest externalDigest, ExternalSignature externalSignature, Certificate[] chain, Collection<CrlClient> crlList, OcspClient ocspClient, TSAClient tsaClient, int estimatedSize, CryptoStandard sigtype) throws IOException, DocumentException, GeneralSecurityException {
        Collection<byte[]> crlBytes = null;
        int i = 0;
        if (chain != null) {
            while (crlBytes == null && i < chain.length) {
                crlBytes = MakeSignature.processCrl(chain[i++], crlList);
            }
        }
        if (estimatedSize == 0) {
            estimatedSize = 8192;
            if (crlBytes != null) {
                for (byte[] element : crlBytes) {
                    estimatedSize += element.length + 10;
                }
            }
            if (ocspClient != null) {
                estimatedSize += 4192;
            }
            if (tsaClient != null) {
                estimatedSize += 4192;
            }
        }
        if (chain != null) {
            sap.setCertificate(chain[0]);
        }
        if (sigtype == CryptoStandard.CADES) {
            sap.addDeveloperExtension(PdfDeveloperExtension.ESIC_1_7_EXTENSIONLEVEL2);
        }
        PdfSignature dic = null;
        DigitalSignatureByKey digitalSignatureByKey = null;
        if (externalSignature instanceof DigitalSignatureByKey) {
            digitalSignatureByKey = (DigitalSignatureByKey)externalSignature;
        }
        if (digitalSignatureByKey != null) {
            if (digitalSignatureByKey.getSigType() == 0) {
                dic = new PdfSignature(PdfName.ADOBE_PPKLITE, PdfName.ADBE_X509_RSA_SHA1);
                dic.setCert(chain[0].getEncoded());
            } else if (digitalSignatureByKey.getSigType() == 1) {
                dic = new PdfSignature(PdfName.ADOBE_PPKLITE, sigtype == CryptoStandard.CADES ? PdfName.ETSI_CADES_DETACHED : PdfName.ADBE_PKCS7_DETACHED);
            }
        } else {
            dic = new PdfSignature(PdfName.ADOBE_PPKLITE, sigtype == CryptoStandard.CADES ? PdfName.ETSI_CADES_DETACHED : PdfName.ADBE_PKCS7_DETACHED);
        }
        dic.setReason(sap.getReason());
        dic.setLocation(sap.getLocation());
        dic.setSignatureCreator(sap.getSignatureCreator());
        dic.setContact(sap.getContact());
        dic.setDate(new PdfDate(sap.getSignDate()));
        sap.setCryptoDictionary(dic);
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.CONTENTS, new Integer(estimatedSize * 2 + 2));
        sap.preClose(exc);
        String hashAlgorithm = externalSignature.getHashAlgorithm();
        InputStream data = sap.getRangeStream();
        byte[] hash = DigestAlgorithms.digest(data, externalDigest.getMessageDigest(hashAlgorithm));
        byte[] paddedSig = new byte[estimatedSize];
        if (digitalSignatureByKey != null && digitalSignatureByKey.getSigType() == 0) {
            digitalSignatureByKey.sign(hash);
            digitalSignatureByKey.setContentsPostion(sap.getContentsPostion());
        } else {
            Calendar cal = Calendar.getInstance();
            byte[] ocsp = null;
            if (chain != null && chain.length >= 2 && ocspClient != null) {
                ocsp = ocspClient.getEncoded((X509Certificate)chain[0], (X509Certificate)chain[1], null);
            }
            PdfPKCS7 sgn = new PdfPKCS7(null, chain, hashAlgorithm, null, externalDigest, false);
            byte[] sh = sgn.getAuthenticatedAttributeBytes(hash, cal, ocsp, crlBytes, sigtype);
            byte[] extSignature = externalSignature.sign(sh);
            if (digitalSignatureByKey != null) {
                digitalSignatureByKey.setContentsPostion(sap.getContentsPostion());
                digitalSignatureByKey.setPdfHash(hash);
                digitalSignatureByKey.setTime(cal.getTimeInMillis());
            } else {
                sgn.setExternalDigest(extSignature, null, externalSignature.getEncryptionAlgorithm());
                byte[] encodedSig = sgn.getEncodedPKCS7(hash, cal, tsaClient, ocsp, crlBytes, sigtype);
                if (estimatedSize < encodedSig.length) {
                    throw new IOException("Not enough space");
                }
                System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
            }
        }
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.CONTENTS, new PdfString(paddedSig).setHexWriting(true));
        sap.close(dic2);
    }

    public static Collection<byte[]> processCrl(Certificate cert, Collection<CrlClient> crlList) {
        if (crlList == null) {
            return null;
        }
        ArrayList<byte[]> crlBytes = new ArrayList<byte[]>();
        for (CrlClient cc : crlList) {
            if (cc == null) continue;
            LOGGER.info("Processing " + cc.getClass().getName());
            Collection<byte[]> b = cc.getEncoded((X509Certificate)cert, null);
            if (b == null) continue;
            crlBytes.addAll(b);
        }
        if (crlBytes.isEmpty()) {
            return null;
        }
        return crlBytes;
    }

    public static void signExternalContainer(PdfSignatureAppearance sap, ExternalSignatureContainer externalSignatureContainer, int estimatedSize) throws GeneralSecurityException, IOException, DocumentException {
        PdfSignature dic = new PdfSignature(null, null);
        dic.setReason(sap.getReason());
        dic.setLocation(sap.getLocation());
        dic.setSignatureCreator(sap.getSignatureCreator());
        dic.setContact(sap.getContact());
        dic.setDate(new PdfDate(sap.getSignDate()));
        externalSignatureContainer.modifySigningDictionary(dic);
        sap.setCryptoDictionary(dic);
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        exc.put(PdfName.CONTENTS, new Integer(estimatedSize * 2 + 2));
        sap.preClose(exc);
        InputStream data = sap.getRangeStream();
        byte[] encodedSig = externalSignatureContainer.sign(data);
        if (estimatedSize < encodedSig.length) {
            throw new IOException("Not enough space");
        }
        byte[] paddedSig = new byte[estimatedSize];
        System.arraycopy(encodedSig, 0, paddedSig, 0, encodedSig.length);
        PdfDictionary dic2 = new PdfDictionary();
        dic2.put(PdfName.CONTENTS, new PdfString(paddedSig).setHexWriting(true));
        sap.close(dic2);
    }

    public static void signDeferred(PdfReader reader, String fieldName, OutputStream outs, ExternalSignatureContainer externalSignatureContainer) throws DocumentException, IOException, GeneralSecurityException {
        AcroFields af = reader.getAcroFields();
        PdfDictionary v = af.getSignatureDictionary(fieldName);
        if (v == null) {
            throw new DocumentException("No field");
        }
        if (!af.signatureCoversWholeDocument(fieldName)) {
            throw new DocumentException("Not the last signature");
        }
        PdfArray b = v.getAsArray(PdfName.BYTERANGE);
        long[] gaps = b.asLongArray();
        if (b.size() != 4 || gaps[0] != 0L) {
            throw new DocumentException("Single exclusion space supported");
        }
        RandomAccessSource readerSource = reader.getSafeFile().createSourceView();
        RASInputStream rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(readerSource, gaps));
        byte[] signedContent = externalSignatureContainer.sign(rg);
        int spaceAvailable = (int)(gaps[2] - gaps[1]) - 2;
        if ((spaceAvailable & 1) != 0) {
            throw new DocumentException("Gap is not a multiple of 2");
        }
        if ((spaceAvailable /= 2) < signedContent.length) {
            throw new DocumentException("Not enough space");
        }
        StreamUtil.CopyBytes(readerSource, 0L, gaps[1] + 1L, outs);
        ByteBuffer bb = new ByteBuffer(spaceAvailable * 2);
        byte[] byArray = signedContent;
        int n = signedContent.length;
        int n2 = 0;
        while (n2 < n) {
            byte bi = byArray[n2];
            bb.appendHex(bi);
            ++n2;
        }
        int remain = (spaceAvailable - signedContent.length) * 2;
        int k = 0;
        while (k < remain) {
            bb.append((byte)48);
            ++k;
        }
        bb.writeTo(outs);
        StreamUtil.CopyBytes(readerSource, gaps[2] - 1L, gaps[3] + 1L, outs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CryptoStandard {
        CMS,
        CADES;

    }
}

