/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.qrcode;

public final class BitArray {
    public int[] bits;
    public final int size;

    public BitArray(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("size must be at least 1");
        }
        this.size = size;
        this.bits = BitArray.makeArray(size);
    }

    public int getSize() {
        return this.size;
    }

    public boolean get(int i) {
        return (this.bits[i >> 5] & 1 << (i & 0x1F)) != 0;
    }

    public void set(int i) {
        int n = i >> 5;
        this.bits[n] = this.bits[n] | 1 << (i & 0x1F);
    }

    public void flip(int i) {
        int n = i >> 5;
        this.bits[n] = this.bits[n] ^ 1 << (i & 0x1F);
    }

    public void setBulk(int i, int newBits) {
        this.bits[i >> 5] = newBits;
    }

    public void clear() {
        int max = this.bits.length;
        int i = 0;
        while (i < max) {
            this.bits[i] = 0;
            ++i;
        }
    }

    public boolean isRange(int start, int end, boolean value) {
        if (end < start) {
            throw new IllegalArgumentException();
        }
        if (end == start) {
            return true;
        }
        int firstInt = start >> 5;
        int lastInt = --end >> 5;
        int i = firstInt;
        while (i <= lastInt) {
            int mask;
            int lastBit;
            int firstBit = i > firstInt ? 0 : start & 0x1F;
            int n = lastBit = i < lastInt ? 31 : end & 0x1F;
            if (firstBit == 0 && lastBit == 31) {
                mask = -1;
            } else {
                mask = 0;
                int j = firstBit;
                while (j <= lastBit) {
                    mask |= 1 << j;
                    ++j;
                }
            }
            if ((this.bits[i] & mask) != (value ? mask : 0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int[] newBits = new int[this.bits.length];
        int size = this.size;
        int i = 0;
        while (i < size) {
            if (this.get(size - i - 1)) {
                int n = i >> 5;
                newBits[n] = newBits[n] | 1 << (i & 0x1F);
            }
            ++i;
        }
        this.bits = newBits;
    }

    private static int[] makeArray(int size) {
        int arraySize = size >> 5;
        if ((size & 0x1F) != 0) {
            ++arraySize;
        }
        return new int[arraySize];
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.size);
        int i = 0;
        while (i < this.size) {
            if ((i & 7) == 0) {
                result.append(' ');
            }
            result.append(this.get(i) ? (char)'X' : '.');
            ++i;
        }
        return result.toString();
    }
}

