/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.parser;

import com.KGitextpdf.text.pdf.parser.ImageRenderInfo;
import com.KGitextpdf.text.pdf.parser.LineSegment;
import com.KGitextpdf.text.pdf.parser.TextExtractionStrategy;
import com.KGitextpdf.text.pdf.parser.TextRenderInfo;
import com.KGitextpdf.text.pdf.parser.Vector;

public class SimpleTextExtractionStrategy
implements TextExtractionStrategy {
    private Vector lastStart;
    private Vector lastEnd;
    private final StringBuffer result = new StringBuffer();

    public void beginTextBlock() {
    }

    public void endTextBlock() {
    }

    public String getResultantText() {
        return this.result.toString();
    }

    protected final void appendTextChunk(CharSequence text) {
        this.result.append(text);
    }

    public void renderText(TextRenderInfo renderInfo) {
        float spacing;
        boolean firstRender = this.result.length() == 0;
        boolean hardReturn = false;
        LineSegment segment = renderInfo.getBaseline();
        Vector start = segment.getStartPoint();
        Vector end = segment.getEndPoint();
        if (!firstRender) {
            float sameLineThreshold;
            Vector x0 = start;
            Vector x2 = this.lastEnd;
            Vector x1 = this.lastStart;
            float dist = x2.subtract(x1).cross(x1.subtract(x0)).lengthSquared() / x2.subtract(x1).lengthSquared();
            if (dist > (sameLineThreshold = 1.0f)) {
                hardReturn = true;
            }
        }
        if (hardReturn) {
            this.appendTextChunk("\n");
        } else if (!firstRender && this.result.charAt(this.result.length() - 1) != ' ' && renderInfo.getText().length() > 0 && renderInfo.getText().charAt(0) != ' ' && (spacing = this.lastEnd.subtract(start).length()) > renderInfo.getSingleSpaceWidth() / 2.0f) {
            this.appendTextChunk(" ");
        }
        this.appendTextChunk(renderInfo.getText());
        this.lastStart = start;
        this.lastEnd = end;
    }

    public void renderImage(ImageRenderInfo renderInfo) {
    }
}

