/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.parser;

import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.parser.InlineImageInfo;
import com.KGitextpdf.text.pdf.parser.Matrix;
import com.KGitextpdf.text.pdf.parser.PdfImageObject;
import com.KGitextpdf.text.pdf.parser.Vector;
import java.io.IOException;

public class ImageRenderInfo {
    private final Matrix ctm;
    private final PdfIndirectReference ref;
    private final InlineImageInfo inlineImageInfo;
    private final PdfDictionary colorSpaceDictionary;
    private PdfImageObject imageObject = null;

    private ImageRenderInfo(Matrix ctm, PdfIndirectReference ref, PdfDictionary colorSpaceDictionary) {
        this.ctm = ctm;
        this.ref = ref;
        this.inlineImageInfo = null;
        this.colorSpaceDictionary = colorSpaceDictionary;
    }

    private ImageRenderInfo(Matrix ctm, InlineImageInfo inlineImageInfo, PdfDictionary colorSpaceDictionary) {
        this.ctm = ctm;
        this.ref = null;
        this.inlineImageInfo = inlineImageInfo;
        this.colorSpaceDictionary = colorSpaceDictionary;
    }

    public static ImageRenderInfo createForXObject(Matrix ctm, PdfIndirectReference ref, PdfDictionary colorSpaceDictionary) {
        return new ImageRenderInfo(ctm, ref, colorSpaceDictionary);
    }

    protected static ImageRenderInfo createForEmbeddedImage(Matrix ctm, InlineImageInfo inlineImageInfo, PdfDictionary colorSpaceDictionary) {
        ImageRenderInfo renderInfo = new ImageRenderInfo(ctm, inlineImageInfo, colorSpaceDictionary);
        return renderInfo;
    }

    public PdfImageObject getImage() throws IOException {
        this.prepareImageObject();
        return this.imageObject;
    }

    private void prepareImageObject() throws IOException {
        if (this.imageObject != null) {
            return;
        }
        if (this.ref != null) {
            PRStream stream = (PRStream)PdfReader.getPdfObject(this.ref);
            this.imageObject = new PdfImageObject(stream, this.colorSpaceDictionary);
        } else if (this.inlineImageInfo != null) {
            this.imageObject = new PdfImageObject(this.inlineImageInfo.getImageDictionary(), this.inlineImageInfo.getSamples(), this.colorSpaceDictionary);
        }
    }

    public Vector getStartPoint() {
        return new Vector(0.0f, 0.0f, 1.0f).cross(this.ctm);
    }

    public Matrix getImageCTM() {
        return this.ctm;
    }

    public float getArea() {
        return this.ctm.getDeterminant();
    }

    public PdfIndirectReference getRef() {
        return this.ref;
    }
}

