/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.fonts.otf;

import com.KGitextpdf.text.pdf.Glyph;
import com.KGitextpdf.text.pdf.fonts.otf.FontReadingException;
import com.KGitextpdf.text.pdf.fonts.otf.OpenTypeFontTableReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphSubstitutionTableReader
extends OpenTypeFontTableReader {
    private final int[] glyphWidthsByIndex;
    private final Map<Integer, Character> glyphToCharacterMap;
    private Map<Integer, List<Integer>> rawLigatureSubstitutionMap;

    public GlyphSubstitutionTableReader(String fontFilePath, int gsubTableLocation, Map<Integer, Character> glyphToCharacterMap, int[] glyphWidthsByIndex) throws IOException {
        super(fontFilePath, gsubTableLocation);
        this.glyphWidthsByIndex = glyphWidthsByIndex;
        this.glyphToCharacterMap = glyphToCharacterMap;
    }

    public void read() throws FontReadingException {
        this.rawLigatureSubstitutionMap = new LinkedHashMap<Integer, List<Integer>>();
        this.startReadingTable();
    }

    public Map<String, Glyph> getGlyphSubstitutionMap() throws FontReadingException {
        LinkedHashMap<String, Glyph> glyphSubstitutionMap = new LinkedHashMap<String, Glyph>();
        for (Integer glyphIdToReplace : this.rawLigatureSubstitutionMap.keySet()) {
            List<Integer> constituentGlyphs = this.rawLigatureSubstitutionMap.get(glyphIdToReplace);
            StringBuilder chars = new StringBuilder(constituentGlyphs.size());
            for (Integer constituentGlyphId : constituentGlyphs) {
                chars.append(this.getTextFromGlyph(constituentGlyphId, this.glyphToCharacterMap));
            }
            Glyph glyph = new Glyph(glyphIdToReplace, this.glyphWidthsByIndex[glyphIdToReplace], chars.toString());
            glyphSubstitutionMap.put(glyph.chars, glyph);
        }
        return Collections.unmodifiableMap(glyphSubstitutionMap);
    }

    private String getTextFromGlyph(int glyphId, Map<Integer, Character> glyphToCharacterMap) throws FontReadingException {
        StringBuilder chars = new StringBuilder(1);
        Character c = glyphToCharacterMap.get(glyphId);
        if (c == null) {
            List<Integer> constituentGlyphs = this.rawLigatureSubstitutionMap.get(glyphId);
            if (constituentGlyphs == null || constituentGlyphs.isEmpty()) {
                throw new FontReadingException("No corresponding character or simple glyphs found for GlyphID=" + glyphId);
            }
            for (int constituentGlyphId : constituentGlyphs) {
                chars.append(this.getTextFromGlyph(constituentGlyphId, glyphToCharacterMap));
            }
        } else {
            chars.append(c.charValue());
        }
        return chars.toString();
    }

    @Override
    protected void readSubTable(int lookupType, int subTableLocation) throws IOException {
        if (lookupType == 1) {
            this.readSingleSubstitutionSubtable(subTableLocation);
        } else if (lookupType == 4) {
            this.readLigatureSubstitutionSubtable(subTableLocation);
        } else {
            System.err.println("LookupType " + lookupType + " is not yet handled for " + GlyphSubstitutionTableReader.class.getSimpleName());
        }
    }

    private void readSingleSubstitutionSubtable(int subTableLocation) throws IOException {
        this.rf.seek(subTableLocation);
        short substFormat = this.rf.readShort();
        LOG.debug("substFormat=" + substFormat);
        if (substFormat == 1) {
            short coverage = this.rf.readShort();
            LOG.debug("coverage=" + coverage);
            short deltaGlyphID = this.rf.readShort();
            LOG.debug("deltaGlyphID=" + deltaGlyphID);
            List<Integer> coverageGlyphIds = this.readCoverageFormat(subTableLocation + coverage);
            for (int coverageGlyphId : coverageGlyphIds) {
                int substituteGlyphId = coverageGlyphId + deltaGlyphID;
                this.rawLigatureSubstitutionMap.put(substituteGlyphId, Arrays.asList(coverageGlyphId));
            }
        } else if (substFormat == 2) {
            System.err.println("LookupType 1 :: substFormat 2 is not yet handled by " + GlyphSubstitutionTableReader.class.getSimpleName());
        } else {
            throw new IllegalArgumentException("Bad substFormat: " + substFormat);
        }
    }

    private void readLigatureSubstitutionSubtable(int ligatureSubstitutionSubtableLocation) throws IOException {
        this.rf.seek(ligatureSubstitutionSubtableLocation);
        short substFormat = this.rf.readShort();
        LOG.debug("substFormat=" + substFormat);
        if (substFormat != 1) {
            throw new IllegalArgumentException("The expected SubstFormat is 1");
        }
        short coverage = this.rf.readShort();
        LOG.debug("coverage=" + coverage);
        int ligSetCount = this.rf.readShort();
        ArrayList<Integer> ligatureOffsets = new ArrayList<Integer>(ligSetCount);
        int i = 0;
        while (i < ligSetCount) {
            short ligatureOffset = this.rf.readShort();
            ligatureOffsets.add(Integer.valueOf(ligatureOffset));
            ++i;
        }
        List<Integer> coverageGlyphIds = this.readCoverageFormat(ligatureSubstitutionSubtableLocation + coverage);
        if (ligSetCount != coverageGlyphIds.size()) {
            throw new IllegalArgumentException("According to the OpenTypeFont specifications, the coverage count should be equal to the no. of LigatureSetTables");
        }
        int i2 = 0;
        while (i2 < ligSetCount) {
            int coverageGlyphId = coverageGlyphIds.get(i2);
            int ligatureOffset = (Integer)ligatureOffsets.get(i2);
            LOG.debug("ligatureOffset=" + ligatureOffset);
            this.readLigatureSetTable(ligatureSubstitutionSubtableLocation + ligatureOffset, coverageGlyphId);
            ++i2;
        }
    }

    private void readLigatureSetTable(int ligatureSetTableLocation, int coverageGlyphId) throws IOException {
        this.rf.seek(ligatureSetTableLocation);
        int ligatureCount = this.rf.readShort();
        LOG.debug("ligatureCount=" + ligatureCount);
        ArrayList<Integer> ligatureOffsets = new ArrayList<Integer>(ligatureCount);
        int i = 0;
        while (i < ligatureCount) {
            short ligatureOffset = this.rf.readShort();
            ligatureOffsets.add(Integer.valueOf(ligatureOffset));
            ++i;
        }
        Iterator iterator = ligatureOffsets.iterator();
        while (iterator.hasNext()) {
            int ligatureOffset = (Integer)iterator.next();
            this.readLigatureTable(ligatureSetTableLocation + ligatureOffset, coverageGlyphId);
        }
    }

    private void readLigatureTable(int ligatureTableLocation, int coverageGlyphId) throws IOException {
        this.rf.seek(ligatureTableLocation);
        short ligGlyph = this.rf.readShort();
        LOG.debug("ligGlyph=" + ligGlyph);
        short compCount = this.rf.readShort();
        ArrayList<Integer> glyphIdList = new ArrayList<Integer>();
        glyphIdList.add(coverageGlyphId);
        int i = 0;
        while (i < compCount - 1) {
            short glyphId = this.rf.readShort();
            glyphIdList.add(Integer.valueOf(glyphId));
            ++i;
        }
        LOG.debug("glyphIdList=" + glyphIdList);
        List previousValue = this.rawLigatureSubstitutionMap.put(Integer.valueOf(ligGlyph), glyphIdList);
        if (previousValue != null) {
            LOG.warn("!!!!!!!!!!glyphId=" + ligGlyph + ",\npreviousValue=" + previousValue + ",\ncurrentVal=" + glyphIdList);
        }
    }
}

