/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.codec;

import com.KGitextpdf.text.DocWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class PngWriter {
    private static final byte[] PNG_SIGNTURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final byte[] IHDR = DocWriter.getISOBytes("IHDR");
    private static final byte[] PLTE = DocWriter.getISOBytes("PLTE");
    private static final byte[] IDAT = DocWriter.getISOBytes("IDAT");
    private static final byte[] IEND = DocWriter.getISOBytes("IEND");
    private static final byte[] iCCP = DocWriter.getISOBytes("iCCP");
    private static int[] crc_table;
    private OutputStream outp;

    public PngWriter(OutputStream outp) throws IOException {
        this.outp = outp;
        outp.write(PNG_SIGNTURE);
    }

    public void writeHeader(int width, int height, int bitDepth, int colorType) throws IOException {
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        PngWriter.outputInt(width, ms);
        PngWriter.outputInt(height, ms);
        ms.write(bitDepth);
        ms.write(colorType);
        ms.write(0);
        ms.write(0);
        ms.write(0);
        this.writeChunk(IHDR, ms.toByteArray());
    }

    public void writeEnd() throws IOException {
        this.writeChunk(IEND, new byte[0]);
    }

    public void writeData(byte[] data, int stride) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DeflaterOutputStream zip = new DeflaterOutputStream(stream);
        int k = 0;
        while (k < data.length - stride) {
            zip.write(0);
            zip.write(data, k, stride);
            k += stride;
        }
        int remaining = data.length - k;
        if (remaining > 0) {
            zip.write(0);
            zip.write(data, k, remaining);
        }
        zip.close();
        this.writeChunk(IDAT, stream.toByteArray());
    }

    public void writePalette(byte[] data) throws IOException {
        this.writeChunk(PLTE, data);
    }

    public void writeIccProfile(byte[] data) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(73);
        stream.write(67);
        stream.write(67);
        stream.write(0);
        stream.write(0);
        DeflaterOutputStream zip = new DeflaterOutputStream(stream);
        zip.write(data);
        zip.close();
        this.writeChunk(iCCP, stream.toByteArray());
    }

    private static void make_crc_table() {
        if (crc_table != null) {
            return;
        }
        int[] crc2 = new int[256];
        int n = 0;
        while (n < 256) {
            int c = n;
            int k = 0;
            while (k < 8) {
                c = (c & 1) != 0 ? 0xEDB88320 ^ c >>> 1 : (c >>>= 1);
                ++k;
            }
            crc2[n] = c;
            ++n;
        }
        crc_table = crc2;
    }

    private static int update_crc(int crc, byte[] buf, int offset, int len) {
        int c = crc;
        if (crc_table == null) {
            PngWriter.make_crc_table();
        }
        int n = 0;
        while (n < len) {
            c = crc_table[(c ^ buf[n + offset]) & 0xFF] ^ c >>> 8;
            ++n;
        }
        return c;
    }

    private static int crc(byte[] buf, int offset, int len) {
        return ~PngWriter.update_crc(-1, buf, offset, len);
    }

    private static int crc(byte[] buf) {
        return ~PngWriter.update_crc(-1, buf, 0, buf.length);
    }

    public void outputInt(int n) throws IOException {
        PngWriter.outputInt(n, this.outp);
    }

    public static void outputInt(int n, OutputStream s) throws IOException {
        s.write((byte)(n >> 24));
        s.write((byte)(n >> 16));
        s.write((byte)(n >> 8));
        s.write((byte)n);
    }

    public void writeChunk(byte[] chunkType, byte[] data) throws IOException {
        this.outputInt(data.length);
        this.outp.write(chunkType, 0, 4);
        this.outp.write(data);
        int c = PngWriter.update_crc(-1, chunkType, 0, chunkType.length);
        c = ~PngWriter.update_crc(c, data, 0, data.length);
        this.outputInt(c);
    }
}

