/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.error_messages.MessageLocalization;
import com.KGitextpdf.text.pdf.BadPdfFormatException;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfBoolean;
import com.KGitextpdf.text.pdf.PdfCopy;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNull;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.PdfStructureTreeRoot;
import com.KGitextpdf.text.pdf.RefKey;
import java.io.IOException;
import java.util.Map;

public class PdfStructTreeController {
    private PdfDictionary structTreeRoot;
    private PdfCopy writer;
    private PdfStructureTreeRoot structureTreeRoot;
    private PdfDictionary parentTree;
    protected PdfReader reader;
    private PdfDictionary roleMap = null;
    private PdfDictionary sourceRoleMap = null;
    private PdfDictionary sourceClassMap = null;
    private PdfIndirectReference nullReference = null;

    protected PdfStructTreeController(PdfReader reader, PdfCopy writer) throws BadPdfFormatException {
        if (!writer.isTagged()) {
            throw new BadPdfFormatException(MessageLocalization.getComposedMessage("no.structtreeroot.found", new Object[0]));
        }
        this.writer = writer;
        this.structureTreeRoot = writer.getStructureTreeRoot();
        this.structureTreeRoot.put(PdfName.PARENTTREE, new PdfDictionary(PdfName.STRUCTELEM));
        this.setReader(reader);
    }

    protected void setReader(PdfReader reader) throws BadPdfFormatException {
        this.reader = reader;
        PdfObject obj = reader.getCatalog().get(PdfName.STRUCTTREEROOT);
        if ((obj = PdfStructTreeController.getDirectObject(obj)) == null || !obj.isDictionary()) {
            throw new BadPdfFormatException(MessageLocalization.getComposedMessage("no.structtreeroot.found", new Object[0]));
        }
        this.structTreeRoot = (PdfDictionary)obj;
        obj = PdfStructTreeController.getDirectObject(this.structTreeRoot.get(PdfName.PARENTTREE));
        if (obj == null || !obj.isDictionary()) {
            throw new BadPdfFormatException(MessageLocalization.getComposedMessage("the.document.does.not.contain.parenttree", new Object[0]));
        }
        this.parentTree = (PdfDictionary)obj;
        this.sourceRoleMap = null;
        this.sourceClassMap = null;
        this.nullReference = null;
    }

    public static boolean checkTagged(PdfReader reader) {
        PdfObject obj = reader.getCatalog().get(PdfName.STRUCTTREEROOT);
        if ((obj = PdfStructTreeController.getDirectObject(obj)) == null || !obj.isDictionary()) {
            return false;
        }
        PdfDictionary structTreeRoot = (PdfDictionary)obj;
        return (obj = PdfStructTreeController.getDirectObject(structTreeRoot.get(PdfName.PARENTTREE))) != null && obj.isDictionary();
    }

    /*
     * Unable to fully structure code
     */
    public static PdfObject getDirectObject(PdfObject object) {
        if (object != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            object = PdfReader.getPdfObjectRelease(object);
lbl4:
            // 2 sources

            ** while (object.isIndirect())
        }
lbl5:
        // 1 sources

        return object;
    }

    public void copyStructTreeForPage(PdfNumber sourceArrayNumber, int newArrayNumber) throws BadPdfFormatException, IOException {
        if (this.copyPageMarks(this.parentTree, sourceArrayNumber, newArrayNumber) == returnType.NOTFOUND) {
            throw new BadPdfFormatException(MessageLocalization.getComposedMessage("invalid.structparent", new Object[0]));
        }
    }

    private returnType copyPageMarks(PdfDictionary parentTree, PdfNumber arrayNumber, int newArrayNumber) throws BadPdfFormatException, IOException {
        PdfArray pages = (PdfArray)PdfStructTreeController.getDirectObject(parentTree.get(PdfName.NUMS));
        if (pages == null) {
            PdfArray kids = (PdfArray)PdfStructTreeController.getDirectObject(parentTree.get(PdfName.KIDS));
            if (kids == null) {
                return returnType.NOTFOUND;
            }
            int cur = kids.size() / 2;
            int begin = 0;
            block5: while (true) {
                PdfDictionary kidTree = (PdfDictionary)PdfStructTreeController.getDirectObject(kids.getPdfObject(cur + begin));
                switch (this.copyPageMarks(kidTree, arrayNumber, newArrayNumber)) {
                    case FOUND: {
                        return returnType.FOUND;
                    }
                    case ABOVE: {
                        begin += cur;
                        if ((cur /= 2) == 0) {
                            cur = 1;
                        }
                        if (cur + begin != kids.size()) continue block5;
                        return returnType.ABOVE;
                    }
                    case BELOW: {
                        if (cur + begin == 0) {
                            return returnType.BELOW;
                        }
                        if (cur == 0) {
                            return returnType.NOTFOUND;
                        }
                        cur /= 2;
                        continue block5;
                    }
                }
                break;
            }
            return returnType.NOTFOUND;
        }
        if (pages.size() == 0) {
            return returnType.NOTFOUND;
        }
        return this.findAndCopyMarks(pages, arrayNumber.intValue(), newArrayNumber);
    }

    private returnType findAndCopyMarks(PdfArray pages, int arrayNumber, int newArrayNumber) throws BadPdfFormatException, IOException {
        if (pages.getAsNumber(0).intValue() > arrayNumber) {
            return returnType.BELOW;
        }
        if (pages.getAsNumber(pages.size() - 2).intValue() < arrayNumber) {
            return returnType.ABOVE;
        }
        int cur = pages.size() / 4;
        int begin = 0;
        while (true) {
            int curNumber;
            if ((curNumber = pages.getAsNumber((begin + cur) * 2).intValue()) == arrayNumber) {
                PdfObject obj;
                PdfObject obj1 = obj = pages.getPdfObject((begin + cur) * 2 + 1);
                while (obj.isIndirect()) {
                    obj = PdfReader.getPdfObjectRelease(obj);
                }
                if (obj.isArray()) {
                    PdfObject firstNotNullKid = null;
                    for (PdfObject numObj : (PdfArray)obj) {
                        if (numObj.isNull()) {
                            if (this.nullReference == null) {
                                this.nullReference = this.writer.addToBody(new PdfNull()).getIndirectReference();
                            }
                            this.structureTreeRoot.setPageMark(newArrayNumber, this.nullReference);
                            continue;
                        }
                        PdfObject res = this.writer.copyObject(numObj, true, false);
                        if (firstNotNullKid == null) {
                            firstNotNullKid = res;
                        }
                        this.structureTreeRoot.setPageMark(newArrayNumber, (PdfIndirectReference)res);
                    }
                    PdfObject structKids = this.structTreeRoot.get(PdfName.K);
                    if (structKids == null || !structKids.isArray() && !structKids.isIndirect()) {
                        this.addKid(this.structureTreeRoot, firstNotNullKid);
                    } else if (structKids.isIndirect()) {
                        this.addKid(structKids);
                    } else {
                        for (PdfObject kid : (PdfArray)structKids) {
                            this.addKid(kid);
                        }
                    }
                } else if (obj.isDictionary()) {
                    PdfDictionary k = PdfStructTreeController.getKDict((PdfDictionary)obj);
                    if (k == null) {
                        return returnType.NOTFOUND;
                    }
                    PdfObject res = this.writer.copyObject(obj1, true, false);
                    this.structureTreeRoot.setAnnotationMark(newArrayNumber, (PdfIndirectReference)res);
                } else {
                    return returnType.NOTFOUND;
                }
                return returnType.FOUND;
            }
            if (curNumber < arrayNumber) {
                begin += cur;
                if ((cur /= 2) == 0) {
                    cur = 1;
                }
                if (cur + begin != pages.size()) continue;
                return returnType.NOTFOUND;
            }
            if (cur + begin == 0) {
                return returnType.BELOW;
            }
            if (cur == 0) {
                return returnType.NOTFOUND;
            }
            cur /= 2;
        }
    }

    static PdfDictionary getKDict(PdfDictionary obj) {
        PdfDictionary k = obj.getAsDict(PdfName.K);
        if (k != null) {
            if (PdfName.OBJR.equals(k.getAsName(PdfName.TYPE))) {
                return k;
            }
        } else {
            PdfArray k1 = obj.getAsArray(PdfName.K);
            if (k1 == null) {
                return null;
            }
            int i = 0;
            while (i < k1.size()) {
                k = k1.getAsDict(i);
                if (k != null && PdfName.OBJR.equals(k.getAsName(PdfName.TYPE))) {
                    return k;
                }
                ++i;
            }
        }
        return null;
    }

    private void addKid(PdfObject obj) throws IOException, BadPdfFormatException {
        if (!obj.isIndirect()) {
            return;
        }
        PRIndirectReference currRef = (PRIndirectReference)obj;
        RefKey key = new RefKey(currRef);
        if (!this.writer.indirects.containsKey(key)) {
            this.writer.copyIndirect(currRef, true, false);
        }
        PdfIndirectReference newKid = this.writer.indirects.get(key).getRef();
        if (this.writer.updateRootKids) {
            this.addKid(this.structureTreeRoot, newKid);
        }
    }

    private static PdfArray getDirectArray(PdfArray in) {
        PdfArray out = new PdfArray();
        int i = 0;
        while (i < in.size()) {
            PdfObject value = PdfStructTreeController.getDirectObject(in.getPdfObject(i));
            if (value != null) {
                if (value.isArray()) {
                    out.add(PdfStructTreeController.getDirectArray((PdfArray)value));
                } else if (value.isDictionary()) {
                    out.add(PdfStructTreeController.getDirectDict((PdfDictionary)value));
                } else {
                    out.add(value);
                }
            }
            ++i;
        }
        return out;
    }

    private static PdfDictionary getDirectDict(PdfDictionary in) {
        PdfDictionary out = new PdfDictionary();
        for (Map.Entry<PdfName, PdfObject> entry : in.hashMap.entrySet()) {
            PdfObject value = PdfStructTreeController.getDirectObject(entry.getValue());
            if (value == null) continue;
            if (value.isArray()) {
                out.put(entry.getKey(), PdfStructTreeController.getDirectArray((PdfArray)value));
                continue;
            }
            if (value.isDictionary()) {
                out.put(entry.getKey(), PdfStructTreeController.getDirectDict((PdfDictionary)value));
                continue;
            }
            out.put(entry.getKey(), value);
        }
        return out;
    }

    public static boolean compareObjects(PdfObject value1, PdfObject value2) {
        if ((value2 = PdfStructTreeController.getDirectObject(value2)) == null) {
            return false;
        }
        if (value1.type() != value2.type()) {
            return false;
        }
        if (value1.isBoolean()) {
            if (value1 == value2) {
                return true;
            }
            if (value2 instanceof PdfBoolean) {
                return ((PdfBoolean)value1).booleanValue() == ((PdfBoolean)value2).booleanValue();
            }
            return false;
        }
        if (value1.isName()) {
            return value1.equals(value2);
        }
        if (value1.isNumber()) {
            if (value1 == value2) {
                return true;
            }
            if (value2 instanceof PdfNumber) {
                return ((PdfNumber)value1).doubleValue() == ((PdfNumber)value2).doubleValue();
            }
            return false;
        }
        if (value1.isNull()) {
            if (value1 == value2) {
                return true;
            }
            return value2 instanceof PdfNull;
        }
        if (value1.isString()) {
            if (value1 == value2) {
                return true;
            }
            if (value2 instanceof PdfString) {
                return ((PdfString)value2).value == null && ((PdfString)value1).value == null || ((PdfString)value1).value != null && ((PdfString)value1).value.equals(((PdfString)value2).value);
            }
            return false;
        }
        if (value1.isArray()) {
            PdfArray array1 = (PdfArray)value1;
            PdfArray array2 = (PdfArray)value2;
            if (array1.size() != array2.size()) {
                return false;
            }
            int i = 0;
            while (i < array1.size()) {
                if (!PdfStructTreeController.compareObjects(array1.getPdfObject(i), array2.getPdfObject(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (value1.isDictionary()) {
            PdfDictionary first = (PdfDictionary)value1;
            PdfDictionary second = (PdfDictionary)value2;
            if (first.size() != second.size()) {
                return false;
            }
            for (PdfName name : first.hashMap.keySet()) {
                if (PdfStructTreeController.compareObjects(first.get(name), second.get(name))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void addClass(PdfObject object) throws BadPdfFormatException {
        if ((object = PdfStructTreeController.getDirectObject(object)).isDictionary()) {
            PdfObject curClass = ((PdfDictionary)object).get(PdfName.C);
            if (curClass == null) {
                return;
            }
            if (curClass.isArray()) {
                PdfArray array = (PdfArray)curClass;
                int i = 0;
                while (i < array.size()) {
                    this.addClass(array.getPdfObject(i));
                    ++i;
                }
            } else if (curClass.isName()) {
                this.addClass(curClass);
            }
        } else if (object.isName()) {
            PdfName name = (PdfName)object;
            if (this.sourceClassMap == null) {
                object = PdfStructTreeController.getDirectObject(this.structTreeRoot.get(PdfName.CLASSMAP));
                if (object == null || !object.isDictionary()) {
                    return;
                }
                this.sourceClassMap = (PdfDictionary)object;
            }
            if ((object = PdfStructTreeController.getDirectObject(this.sourceClassMap.get(name))) == null) {
                return;
            }
            PdfObject put = this.structureTreeRoot.getMappedClass(name);
            if (put != null) {
                if (!PdfStructTreeController.compareObjects(put, object)) {
                    throw new BadPdfFormatException(MessageLocalization.getComposedMessage("conflict.in.classmap", name));
                }
            } else if (object.isDictionary()) {
                this.structureTreeRoot.mapClass(name, PdfStructTreeController.getDirectDict((PdfDictionary)object));
            } else if (object.isArray()) {
                this.structureTreeRoot.mapClass(name, PdfStructTreeController.getDirectArray((PdfArray)object));
            }
        }
    }

    protected void addRole(PdfName structType) throws BadPdfFormatException {
        PdfObject object;
        if (structType == null) {
            return;
        }
        for (PdfName name : this.writer.getStandardStructElems()) {
            if (!name.equals(structType)) continue;
            return;
        }
        if (this.sourceRoleMap == null) {
            object = PdfStructTreeController.getDirectObject(this.structTreeRoot.get(PdfName.ROLEMAP));
            if (object == null || !object.isDictionary()) {
                return;
            }
            this.sourceRoleMap = (PdfDictionary)object;
        }
        if ((object = this.sourceRoleMap.get(structType)) == null || !object.isName()) {
            return;
        }
        if (this.roleMap == null) {
            this.roleMap = new PdfDictionary();
            this.structureTreeRoot.put(PdfName.ROLEMAP, this.roleMap);
            this.roleMap.put(structType, object);
        } else {
            PdfObject currentRole = this.roleMap.get(structType);
            if (currentRole != null) {
                if (!currentRole.equals(object)) {
                    throw new BadPdfFormatException(MessageLocalization.getComposedMessage("conflict.in.rolemap", object));
                }
            } else {
                this.roleMap.put(structType, object);
            }
        }
    }

    protected void addKid(PdfDictionary parent, PdfObject kid) {
        PdfArray kids;
        PdfObject kidObj = parent.get(PdfName.K);
        if (kidObj instanceof PdfArray) {
            kids = (PdfArray)kidObj;
        } else {
            kids = new PdfArray();
            if (kidObj != null) {
                kids.add(kidObj);
            }
        }
        kids.add(kid);
        parent.put(PdfName.K, kids);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum returnType {
        BELOW,
        FOUND,
        ABOVE,
        NOTFOUND;

    }
}

