/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfNumberTree {
    private static final int leafSize = 64;

    public static <O extends PdfObject> PdfDictionary writeTree(HashMap<Integer, O> items, PdfWriter writer) throws IOException {
        if (items.isEmpty()) {
            return null;
        }
        Object[] numbers = new Integer[items.size()];
        numbers = items.keySet().toArray(numbers);
        Arrays.sort(numbers);
        if (numbers.length <= 64) {
            PdfDictionary dic = new PdfDictionary();
            PdfArray ar = new PdfArray();
            int k = 0;
            while (k < numbers.length) {
                ar.add(new PdfNumber((Integer)numbers[k]));
                ar.add((PdfObject)items.get(numbers[k]));
                ++k;
            }
            dic.put(PdfName.NUMS, ar);
            return dic;
        }
        int skip = 64;
        PdfIndirectReference[] kids = new PdfIndirectReference[(numbers.length + 64 - 1) / 64];
        int k = 0;
        while (k < kids.length) {
            int offset = k * 64;
            int end = Math.min(offset + 64, numbers.length);
            PdfDictionary dic = new PdfDictionary();
            PdfArray arr = new PdfArray();
            arr.add(new PdfNumber((Integer)numbers[offset]));
            arr.add(new PdfNumber((Integer)numbers[end - 1]));
            dic.put(PdfName.LIMITS, arr);
            arr = new PdfArray();
            while (offset < end) {
                arr.add(new PdfNumber((Integer)numbers[offset]));
                arr.add((PdfObject)items.get(numbers[offset]));
                ++offset;
            }
            dic.put(PdfName.NUMS, arr);
            kids[k] = writer.addToBody(dic).getIndirectReference();
            ++k;
        }
        int top = kids.length;
        while (true) {
            int k2;
            if (top <= 64) {
                PdfArray arr = new PdfArray();
                k2 = 0;
                while (k2 < top) {
                    arr.add(kids[k2]);
                    ++k2;
                }
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.KIDS, arr);
                return dic;
            }
            int tt = (numbers.length + (skip *= 64) - 1) / skip;
            k2 = 0;
            while (k2 < tt) {
                int offset = k2 * 64;
                int end = Math.min(offset + 64, top);
                PdfDictionary dic = new PdfDictionary();
                PdfArray arr = new PdfArray();
                arr.add(new PdfNumber((Integer)numbers[k2 * skip]));
                arr.add(new PdfNumber((Integer)numbers[Math.min((k2 + 1) * skip, numbers.length) - 1]));
                dic.put(PdfName.LIMITS, arr);
                arr = new PdfArray();
                while (offset < end) {
                    arr.add(kids[offset]);
                    ++offset;
                }
                dic.put(PdfName.KIDS, arr);
                kids[k2] = writer.addToBody(dic).getIndirectReference();
                ++k2;
            }
            top = tt;
        }
    }

    private static void iterateItems(PdfDictionary dic, HashMap<Integer, PdfObject> items) {
        block3: {
            PdfArray nn;
            block2: {
                nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.NUMS));
                if (nn == null) break block2;
                int k = 0;
                while (k < nn.size()) {
                    PdfNumber s = (PdfNumber)PdfReader.getPdfObjectRelease(nn.getPdfObject(k++));
                    items.put(s.intValue(), nn.getPdfObject(k));
                    ++k;
                }
                break block3;
            }
            nn = (PdfArray)PdfReader.getPdfObjectRelease(dic.get(PdfName.KIDS));
            if (nn == null) break block3;
            int k = 0;
            while (k < nn.size()) {
                PdfDictionary kid = (PdfDictionary)PdfReader.getPdfObjectRelease(nn.getPdfObject(k));
                PdfNumberTree.iterateItems(kid, items);
                ++k;
            }
        }
    }

    public static HashMap<Integer, PdfObject> readTree(PdfDictionary dic) {
        HashMap<Integer, PdfObject> items = new HashMap<Integer, PdfObject>();
        if (dic != null) {
            PdfNumberTree.iterateItems(dic, items);
        }
        return items;
    }
}

