/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.error_messages.MessageLocalization;
import com.KGitextpdf.text.pdf.AcroFields;
import com.KGitextpdf.text.pdf.IntHashtable;
import com.KGitextpdf.text.pdf.PdfCopyFieldsImp;
import com.KGitextpdf.text.pdf.PdfReader;
import java.io.OutputStream;
import java.util.Map;

class PdfCopyFormsImp
extends PdfCopyFieldsImp {
    PdfCopyFormsImp(OutputStream os) throws DocumentException {
        super(os);
    }

    public void copyDocumentFields(PdfReader reader) throws DocumentException {
        if (!reader.isOpenedWithFullPermissions()) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("pdfreader.not.opened.with.owner.password", new Object[0]));
        }
        if (this.readers2intrefs.containsKey(reader)) {
            reader = new PdfReader(reader);
        } else {
            if (reader.isTampered()) {
                throw new DocumentException(MessageLocalization.getComposedMessage("the.document.was.reused", new Object[0]));
            }
            reader.consolidateNamedDestinations();
            reader.setTampered(true);
        }
        reader.shuffleSubsetNames();
        this.readers2intrefs.put(reader, new IntHashtable());
        this.fields.add(reader.getAcroFields());
        this.updateCalculationOrder(reader);
    }

    void mergeFields() {
        int k = 0;
        while (k < this.fields.size()) {
            Map<String, AcroFields.Item> fd = ((AcroFields)this.fields.get(k)).getFields();
            this.mergeWithMaster(fd);
            ++k;
        }
    }
}

