/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.ExceptionConverter;
import com.KGitextpdf.text.Utilities;
import com.KGitextpdf.text.error_messages.MessageLocalization;
import com.KGitextpdf.text.pdf.DocumentFont;
import com.KGitextpdf.text.pdf.IntHashtable;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.fonts.cmaps.CMapByteCid;
import com.KGitextpdf.text.pdf.fonts.cmaps.CMapCache;
import com.KGitextpdf.text.pdf.fonts.cmaps.CMapCidUni;
import com.KGitextpdf.text.pdf.fonts.cmaps.CMapParserEx;
import com.KGitextpdf.text.pdf.fonts.cmaps.CMapSequence;
import com.KGitextpdf.text.pdf.fonts.cmaps.CMapToUnicode;
import com.KGitextpdf.text.pdf.fonts.cmaps.CidLocationFromByte;
import com.KGitextpdf.text.pdf.fonts.cmaps.IdentityToUnicode;
import java.io.IOException;
import java.util.Map;

public class CMapAwareDocumentFont
extends DocumentFont {
    private PdfDictionary fontDic;
    private int spaceWidth;
    private CMapToUnicode toUnicodeCmap;
    private CMapByteCid byteCid;
    private CMapCidUni cidUni;
    private char[] cidbyte2uni;
    private Map<Integer, Integer> uni2cid;

    public CMapAwareDocumentFont(PdfDictionary font) {
        super(font);
        this.fontDic = font;
        this.initFont();
    }

    public CMapAwareDocumentFont(PRIndirectReference refFont) {
        super(refFont);
        this.fontDic = (PdfDictionary)PdfReader.getPdfObjectRelease(refFont);
        this.initFont();
    }

    private void initFont() {
        this.processToUnicode();
        try {
            this.processUni2Byte();
            this.spaceWidth = super.getWidth(32);
            if (this.spaceWidth == 0) {
                this.spaceWidth = this.computeAverageWidth();
            }
            if (this.cjkEncoding != null) {
                this.byteCid = CMapCache.getCachedCMapByteCid(this.cjkEncoding);
                this.cidUni = CMapCache.getCachedCMapCidUni(this.uniMap);
            }
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
    }

    private void processToUnicode() {
        PdfObject toUni = PdfReader.getPdfObjectRelease(this.fontDic.get(PdfName.TOUNICODE));
        if (toUni instanceof PRStream) {
            try {
                byte[] touni = PdfReader.getStreamBytes((PRStream)toUni);
                CidLocationFromByte lb = new CidLocationFromByte(touni);
                this.toUnicodeCmap = new CMapToUnicode();
                CMapParserEx.parseCid("", this.toUnicodeCmap, lb);
                this.uni2cid = this.toUnicodeCmap.createReverseMapping();
            }
            catch (IOException e) {
                this.toUnicodeCmap = null;
                this.uni2cid = null;
            }
        } else if (this.isType0) {
            try {
                PdfName encodingName = this.fontDic.getAsName(PdfName.ENCODING);
                if (encodingName == null) {
                    return;
                }
                String enc = PdfName.decodeName(encodingName.toString());
                if (!enc.equals("Identity-H")) {
                    return;
                }
                PdfArray df = (PdfArray)PdfReader.getPdfObjectRelease(this.fontDic.get(PdfName.DESCENDANTFONTS));
                PdfDictionary cidft = (PdfDictionary)PdfReader.getPdfObjectRelease(df.getPdfObject(0));
                PdfDictionary cidinfo = cidft.getAsDict(PdfName.CIDSYSTEMINFO);
                if (cidinfo == null) {
                    return;
                }
                PdfString ordering = cidinfo.getAsString(PdfName.ORDERING);
                if (ordering == null) {
                    return;
                }
                CMapToUnicode touni = IdentityToUnicode.GetMapFromOrdering(ordering.toUnicodeString());
                if (touni == null) {
                    return;
                }
                this.toUnicodeCmap = touni;
                this.uni2cid = this.toUnicodeCmap.createReverseMapping();
            }
            catch (IOException e) {
                this.toUnicodeCmap = null;
                this.uni2cid = null;
            }
        }
    }

    private void processUni2Byte() throws IOException {
        IntHashtable diffmap;
        IntHashtable byte2uni = this.getByte2Uni();
        int[] e = byte2uni.toOrderedKeys();
        if (e.length == 0) {
            return;
        }
        this.cidbyte2uni = new char[256];
        int k = 0;
        while (k < e.length) {
            int key = e[k];
            this.cidbyte2uni[key] = (char)byte2uni.get(key);
            ++k;
        }
        if (this.toUnicodeCmap != null) {
            Map<Integer, Integer> dm = this.toUnicodeCmap.createDirectMapping();
            for (Map.Entry<Integer, Integer> kv : dm.entrySet()) {
                if (kv.getKey() >= 256) continue;
                this.cidbyte2uni[kv.getKey().intValue()] = (char)kv.getValue().intValue();
            }
        }
        if ((diffmap = this.getDiffmap()) != null) {
            e = diffmap.toOrderedKeys();
            int k2 = 0;
            while (k2 < e.length) {
                int n = diffmap.get(e[k2]);
                if (n < 256) {
                    this.cidbyte2uni[n] = (char)e[k2];
                }
                ++k2;
            }
        }
    }

    private int computeAverageWidth() {
        int count = 0;
        int total = 0;
        int i = 0;
        while (i < this.widths.length) {
            if (this.widths[i] != 0) {
                total += this.widths[i];
                ++count;
            }
            ++i;
        }
        return count != 0 ? total / count : 0;
    }

    public int getWidth(int char1) {
        if (char1 == 32) {
            return this.spaceWidth;
        }
        return super.getWidth(char1);
    }

    private String decodeSingleCID(byte[] bytes, int offset, int len) {
        if (this.toUnicodeCmap != null) {
            if (offset + len > bytes.length) {
                throw new ArrayIndexOutOfBoundsException(MessageLocalization.getComposedMessage("invalid.index.1", offset + len));
            }
            String s = this.toUnicodeCmap.lookup(bytes, offset, len);
            if (s != null) {
                return s;
            }
            if (len != 1 || this.cidbyte2uni == null) {
                return null;
            }
        }
        if (len == 1) {
            if (this.cidbyte2uni == null) {
                return "";
            }
            return new String(this.cidbyte2uni, 0xFF & bytes[offset], 1);
        }
        throw new Error("Multi-byte glyphs not implemented yet");
    }

    public String decode(byte[] cidbytes, int offset, int len) {
        StringBuilder sb = new StringBuilder();
        if (this.toUnicodeCmap == null && this.byteCid != null) {
            CMapSequence seq = new CMapSequence(cidbytes, offset, len);
            String cid = this.byteCid.decodeSequence(seq);
            int k = 0;
            while (k < cid.length()) {
                int c = this.cidUni.lookup(cid.charAt(k));
                if (c > 0) {
                    sb.append(Utilities.convertFromUtf32(c));
                }
                ++k;
            }
        } else {
            int i = offset;
            while (i < offset + len) {
                String rslt = this.decodeSingleCID(cidbytes, i, 1);
                if (rslt == null && i < offset + len - 1) {
                    rslt = this.decodeSingleCID(cidbytes, i, 2);
                    ++i;
                }
                if (rslt != null) {
                    sb.append(rslt);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public String encode(byte[] bytes, int offset, int len) {
        return this.decode(bytes, offset, len);
    }
}

