/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.BadElementException;
import com.KGitextpdf.text.ExceptionConverter;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.pdf.codec.CCITTG4Encoder;
import com.KGitextpdf.text.pdf.qrcode.ByteMatrix;
import com.KGitextpdf.text.pdf.qrcode.EncodeHintType;
import com.KGitextpdf.text.pdf.qrcode.QRCodeWriter;
import com.KGitextpdf.text.pdf.qrcode.WriterException;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.image.MemoryImageSource;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarcodeQRCode {
    ByteMatrix bm;

    public BarcodeQRCode(String content, int width, int height, Map<EncodeHintType, Object> hints) {
        try {
            QRCodeWriter qc = new QRCodeWriter();
            this.bm = qc.encode(content, width, height, hints);
        }
        catch (WriterException ex) {
            throw new ExceptionConverter(ex);
        }
    }

    private byte[] getBitMatrix() {
        int width = this.bm.getWidth();
        int height = this.bm.getHeight();
        int stride = (width + 7) / 8;
        byte[] b = new byte[stride * height];
        byte[][] mt = this.bm.getArray();
        int y = 0;
        while (y < height) {
            byte[] line = mt[y];
            int x = 0;
            while (x < width) {
                if (line[x] != 0) {
                    int offset;
                    int n = offset = stride * y + x / 8;
                    b[n] = (byte)(b[n] | (byte)(128 >> x % 8));
                }
                ++x;
            }
            ++y;
        }
        return b;
    }

    public Image getImage() throws BadElementException {
        byte[] b = this.getBitMatrix();
        byte[] g4 = CCITTG4Encoder.compress(b, this.bm.getWidth(), this.bm.getHeight());
        return Image.getInstance(this.bm.getWidth(), this.bm.getHeight(), false, 256, 1, g4, null);
    }

    public java.awt.Image createAwtImage(Color foreground, Color background) {
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        int width = this.bm.getWidth();
        int height = this.bm.getHeight();
        int[] pix = new int[width * height];
        byte[][] mt = this.bm.getArray();
        int y = 0;
        while (y < height) {
            byte[] line = mt[y];
            int x = 0;
            while (x < width) {
                pix[y * width + x] = line[x] == 0 ? f : g;
                ++x;
            }
            ++y;
        }
        java.awt.Image img = canvas.createImage(new MemoryImageSource(width, height, pix, 0, width));
        return img;
    }
}

