/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.html.simpleparser;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.html.simpleparser.HTMLTagProcessor;
import com.KGitextpdf.text.html.simpleparser.HTMLWorker;
import com.KGitextpdf.text.html.simpleparser.TableWrapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTagProcessors
extends HashMap<String, HTMLTagProcessor> {
    public static final HTMLTagProcessor EM_STRONG_STRIKE_SUP_SUP = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) {
            tag = this.mapTag(tag);
            attrs.put(tag, null);
            worker.updateChain(tag, attrs);
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) {
            tag = this.mapTag(tag);
            worker.updateChain(tag);
        }

        private String mapTag(String tag) {
            if ("em".equalsIgnoreCase(tag)) {
                return "i";
            }
            if ("strong".equalsIgnoreCase(tag)) {
                return "b";
            }
            if ("strike".equalsIgnoreCase(tag)) {
                return "s";
            }
            return tag;
        }
    };
    public static final HTMLTagProcessor A = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) {
            worker.updateChain(tag, attrs);
            worker.flushContent();
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) {
            worker.processLink();
            worker.updateChain(tag);
        }
    };
    public static final HTMLTagProcessor BR = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) {
            worker.newLine();
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) {
        }
    };
    public static final HTMLTagProcessor UL_OL = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) throws DocumentException {
            worker.carriageReturn();
            if (worker.isPendingLI()) {
                worker.endElement("li");
            }
            worker.setSkipText(true);
            worker.updateChain(tag, attrs);
            worker.pushToStack(worker.createList(tag));
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) throws DocumentException {
            worker.carriageReturn();
            if (worker.isPendingLI()) {
                worker.endElement("li");
            }
            worker.setSkipText(false);
            worker.updateChain(tag);
            worker.processList();
        }
    };
    public static final HTMLTagProcessor HR = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) throws DocumentException {
            worker.carriageReturn();
            worker.pushToStack(worker.createLineSeparator(attrs));
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) {
        }
    };
    public static final HTMLTagProcessor SPAN = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) {
            worker.updateChain(tag, attrs);
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) {
            worker.updateChain(tag);
        }
    };
    public static final HTMLTagProcessor H = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) throws DocumentException {
            worker.carriageReturn();
            if (!attrs.containsKey("size")) {
                int v = 7 - Integer.parseInt(tag.substring(1));
                attrs.put("size", Integer.toString(v));
            }
            worker.updateChain(tag, attrs);
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) throws DocumentException {
            worker.carriageReturn();
            worker.updateChain(tag);
        }
    };
    public static final HTMLTagProcessor LI = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) throws DocumentException {
            worker.carriageReturn();
            if (worker.isPendingLI()) {
                worker.endElement(tag);
            }
            worker.setSkipText(false);
            worker.setPendingLI(true);
            worker.updateChain(tag, attrs);
            worker.pushToStack(worker.createListItem());
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) throws DocumentException {
            worker.carriageReturn();
            worker.setPendingLI(false);
            worker.setSkipText(true);
            worker.updateChain(tag);
            worker.processListItem();
        }
    };
    public static final HTMLTagProcessor PRE = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) throws DocumentException {
            worker.carriageReturn();
            if (!attrs.containsKey("face")) {
                attrs.put("face", "Courier");
            }
            worker.updateChain(tag, attrs);
            worker.setInsidePRE(true);
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) throws DocumentException {
            worker.carriageReturn();
            worker.updateChain(tag);
            worker.setInsidePRE(false);
        }
    };
    public static final HTMLTagProcessor DIV = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) throws DocumentException {
            worker.carriageReturn();
            worker.updateChain(tag, attrs);
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) throws DocumentException {
            worker.carriageReturn();
            worker.updateChain(tag);
        }
    };
    public static final HTMLTagProcessor TABLE = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) throws DocumentException {
            worker.carriageReturn();
            TableWrapper table = new TableWrapper(attrs);
            worker.pushToStack(table);
            worker.pushTableState();
            worker.setPendingTD(false);
            worker.setPendingTR(false);
            worker.setSkipText(true);
            attrs.remove("align");
            attrs.put("colspan", "1");
            attrs.put("rowspan", "1");
            worker.updateChain(tag, attrs);
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) throws DocumentException {
            worker.carriageReturn();
            if (worker.isPendingTR()) {
                worker.endElement("tr");
            }
            worker.updateChain(tag);
            worker.processTable();
            worker.popTableState();
            worker.setSkipText(false);
        }
    };
    public static final HTMLTagProcessor TR = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) throws DocumentException {
            worker.carriageReturn();
            if (worker.isPendingTR()) {
                worker.endElement(tag);
            }
            worker.setSkipText(true);
            worker.setPendingTR(true);
            worker.updateChain(tag, attrs);
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) throws DocumentException {
            worker.carriageReturn();
            if (worker.isPendingTD()) {
                worker.endElement("td");
            }
            worker.setPendingTR(false);
            worker.updateChain(tag);
            worker.processRow();
            worker.setSkipText(true);
        }
    };
    public static final HTMLTagProcessor TD = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) throws DocumentException {
            worker.carriageReturn();
            if (worker.isPendingTD()) {
                worker.endElement(tag);
            }
            worker.setSkipText(false);
            worker.setPendingTD(true);
            worker.updateChain("td", attrs);
            worker.pushToStack(worker.createCell(tag));
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) throws DocumentException {
            worker.carriageReturn();
            worker.setPendingTD(false);
            worker.updateChain("td");
            worker.setSkipText(true);
        }
    };
    public static final HTMLTagProcessor IMG = new HTMLTagProcessor(){

        @Override
        public void startElement(HTMLWorker worker, String tag, Map<String, String> attrs) throws DocumentException, IOException {
            worker.updateChain(tag, attrs);
            worker.processImage(worker.createImage(attrs), attrs);
            worker.updateChain(tag);
        }

        @Override
        public void endElement(HTMLWorker worker, String tag) {
        }
    };
    private static final long serialVersionUID = -959260811961222824L;

    public HTMLTagProcessors() {
        this.put("a", A);
        this.put("b", EM_STRONG_STRIKE_SUP_SUP);
        this.put("body", DIV);
        this.put("br", BR);
        this.put("div", DIV);
        this.put("em", EM_STRONG_STRIKE_SUP_SUP);
        this.put("font", SPAN);
        this.put("h1", H);
        this.put("h2", H);
        this.put("h3", H);
        this.put("h4", H);
        this.put("h5", H);
        this.put("h6", H);
        this.put("hr", HR);
        this.put("i", EM_STRONG_STRIKE_SUP_SUP);
        this.put("img", IMG);
        this.put("li", LI);
        this.put("ol", UL_OL);
        this.put("p", DIV);
        this.put("pre", PRE);
        this.put("s", EM_STRONG_STRIKE_SUP_SUP);
        this.put("span", SPAN);
        this.put("strike", EM_STRONG_STRIKE_SUP_SUP);
        this.put("strong", EM_STRONG_STRIKE_SUP_SUP);
        this.put("sub", EM_STRONG_STRIKE_SUP_SUP);
        this.put("sup", EM_STRONG_STRIKE_SUP_SUP);
        this.put("table", TABLE);
        this.put("td", TD);
        this.put("th", TD);
        this.put("tr", TR);
        this.put("u", EM_STRONG_STRIKE_SUP_SUP);
        this.put("ul", UL_OL);
    }
}

