/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.html;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.error_messages.MessageLocalization;
import java.util.HashMap;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebColors
extends HashMap<String, int[]> {
    private static final long serialVersionUID = 3542523100813372896L;
    public static final WebColors NAMES = new WebColors();

    static {
        NAMES.put("aliceblue", new int[]{240, 248, 255, 255});
        NAMES.put("antiquewhite", new int[]{250, 235, 215, 255});
        int[] nArray = new int[4];
        nArray[1] = 255;
        nArray[2] = 255;
        nArray[3] = 255;
        NAMES.put("aqua", nArray);
        NAMES.put("aquamarine", new int[]{127, 255, 212, 255});
        NAMES.put("azure", new int[]{240, 255, 255, 255});
        NAMES.put("beige", new int[]{245, 245, 220, 255});
        NAMES.put("bisque", new int[]{255, 228, 196, 255});
        int[] nArray2 = new int[4];
        nArray2[3] = 255;
        NAMES.put("black", nArray2);
        NAMES.put("blanchedalmond", new int[]{255, 235, 205, 255});
        int[] nArray3 = new int[4];
        nArray3[2] = 255;
        nArray3[3] = 255;
        NAMES.put("blue", nArray3);
        NAMES.put("blueviolet", new int[]{138, 43, 226, 255});
        NAMES.put("brown", new int[]{165, 42, 42, 255});
        NAMES.put("burlywood", new int[]{222, 184, 135, 255});
        NAMES.put("cadetblue", new int[]{95, 158, 160, 255});
        int[] nArray4 = new int[4];
        nArray4[0] = 127;
        nArray4[1] = 255;
        nArray4[3] = 255;
        NAMES.put("chartreuse", nArray4);
        NAMES.put("chocolate", new int[]{210, 105, 30, 255});
        NAMES.put("coral", new int[]{255, 127, 80, 255});
        NAMES.put("cornflowerblue", new int[]{100, 149, 237, 255});
        NAMES.put("cornsilk", new int[]{255, 248, 220, 255});
        NAMES.put("crimson", new int[]{220, 20, 60, 255});
        int[] nArray5 = new int[4];
        nArray5[1] = 255;
        nArray5[2] = 255;
        nArray5[3] = 255;
        NAMES.put("cyan", nArray5);
        int[] nArray6 = new int[4];
        nArray6[2] = 139;
        nArray6[3] = 255;
        NAMES.put("darkblue", nArray6);
        int[] nArray7 = new int[4];
        nArray7[1] = 139;
        nArray7[2] = 139;
        nArray7[3] = 255;
        NAMES.put("darkcyan", nArray7);
        NAMES.put("darkgoldenrod", new int[]{184, 134, 11, 255});
        NAMES.put("darkgray", new int[]{169, 169, 169, 255});
        int[] nArray8 = new int[4];
        nArray8[1] = 100;
        nArray8[3] = 255;
        NAMES.put("darkgreen", nArray8);
        NAMES.put("darkkhaki", new int[]{189, 183, 107, 255});
        int[] nArray9 = new int[4];
        nArray9[0] = 139;
        nArray9[2] = 139;
        nArray9[3] = 255;
        NAMES.put("darkmagenta", nArray9);
        NAMES.put("darkolivegreen", new int[]{85, 107, 47, 255});
        int[] nArray10 = new int[4];
        nArray10[0] = 255;
        nArray10[1] = 140;
        nArray10[3] = 255;
        NAMES.put("darkorange", nArray10);
        NAMES.put("darkorchid", new int[]{153, 50, 204, 255});
        int[] nArray11 = new int[4];
        nArray11[0] = 139;
        nArray11[3] = 255;
        NAMES.put("darkred", nArray11);
        NAMES.put("darksalmon", new int[]{233, 150, 122, 255});
        NAMES.put("darkseagreen", new int[]{143, 188, 143, 255});
        NAMES.put("darkslateblue", new int[]{72, 61, 139, 255});
        NAMES.put("darkslategray", new int[]{47, 79, 79, 255});
        int[] nArray12 = new int[4];
        nArray12[1] = 206;
        nArray12[2] = 209;
        nArray12[3] = 255;
        NAMES.put("darkturquoise", nArray12);
        int[] nArray13 = new int[4];
        nArray13[0] = 148;
        nArray13[2] = 211;
        nArray13[3] = 255;
        NAMES.put("darkviolet", nArray13);
        NAMES.put("deeppink", new int[]{255, 20, 147, 255});
        int[] nArray14 = new int[4];
        nArray14[1] = 191;
        nArray14[2] = 255;
        nArray14[3] = 255;
        NAMES.put("deepskyblue", nArray14);
        NAMES.put("dimgray", new int[]{105, 105, 105, 255});
        NAMES.put("dodgerblue", new int[]{30, 144, 255, 255});
        NAMES.put("firebrick", new int[]{178, 34, 34, 255});
        NAMES.put("floralwhite", new int[]{255, 250, 240, 255});
        NAMES.put("forestgreen", new int[]{34, 139, 34, 255});
        int[] nArray15 = new int[4];
        nArray15[0] = 255;
        nArray15[2] = 255;
        nArray15[3] = 255;
        NAMES.put("fuchsia", nArray15);
        NAMES.put("gainsboro", new int[]{220, 220, 220, 255});
        NAMES.put("ghostwhite", new int[]{248, 248, 255, 255});
        int[] nArray16 = new int[4];
        nArray16[0] = 255;
        nArray16[1] = 215;
        nArray16[3] = 255;
        NAMES.put("gold", nArray16);
        NAMES.put("goldenrod", new int[]{218, 165, 32, 255});
        NAMES.put("gray", new int[]{128, 128, 128, 255});
        int[] nArray17 = new int[4];
        nArray17[1] = 128;
        nArray17[3] = 255;
        NAMES.put("green", nArray17);
        NAMES.put("greenyellow", new int[]{173, 255, 47, 255});
        NAMES.put("honeydew", new int[]{240, 255, 240, 255});
        NAMES.put("hotpink", new int[]{255, 105, 180, 255});
        NAMES.put("indianred", new int[]{205, 92, 92, 255});
        int[] nArray18 = new int[4];
        nArray18[0] = 75;
        nArray18[2] = 130;
        nArray18[3] = 255;
        NAMES.put("indigo", nArray18);
        NAMES.put("ivory", new int[]{255, 255, 240, 255});
        NAMES.put("khaki", new int[]{240, 230, 140, 255});
        NAMES.put("lavender", new int[]{230, 230, 250, 255});
        NAMES.put("lavenderblush", new int[]{255, 240, 245, 255});
        int[] nArray19 = new int[4];
        nArray19[0] = 124;
        nArray19[1] = 252;
        nArray19[3] = 255;
        NAMES.put("lawngreen", nArray19);
        NAMES.put("lemonchiffon", new int[]{255, 250, 205, 255});
        NAMES.put("lightblue", new int[]{173, 216, 230, 255});
        NAMES.put("lightcoral", new int[]{240, 128, 128, 255});
        NAMES.put("lightcyan", new int[]{224, 255, 255, 255});
        NAMES.put("lightgoldenrodyellow", new int[]{250, 250, 210, 255});
        NAMES.put("lightgreen", new int[]{144, 238, 144, 255});
        NAMES.put("lightgrey", new int[]{211, 211, 211, 255});
        NAMES.put("lightpink", new int[]{255, 182, 193, 255});
        NAMES.put("lightsalmon", new int[]{255, 160, 122, 255});
        NAMES.put("lightseagreen", new int[]{32, 178, 170, 255});
        NAMES.put("lightskyblue", new int[]{135, 206, 250, 255});
        NAMES.put("lightslategray", new int[]{119, 136, 153, 255});
        NAMES.put("lightsteelblue", new int[]{176, 196, 222, 255});
        NAMES.put("lightyellow", new int[]{255, 255, 224, 255});
        int[] nArray20 = new int[4];
        nArray20[1] = 255;
        nArray20[3] = 255;
        NAMES.put("lime", nArray20);
        NAMES.put("limegreen", new int[]{50, 205, 50, 255});
        NAMES.put("linen", new int[]{250, 240, 230, 255});
        int[] nArray21 = new int[4];
        nArray21[0] = 255;
        nArray21[2] = 255;
        nArray21[3] = 255;
        NAMES.put("magenta", nArray21);
        int[] nArray22 = new int[4];
        nArray22[0] = 128;
        nArray22[3] = 255;
        NAMES.put("maroon", nArray22);
        NAMES.put("mediumaquamarine", new int[]{102, 205, 170, 255});
        int[] nArray23 = new int[4];
        nArray23[2] = 205;
        nArray23[3] = 255;
        NAMES.put("mediumblue", nArray23);
        NAMES.put("mediumorchid", new int[]{186, 85, 211, 255});
        NAMES.put("mediumpurple", new int[]{147, 112, 219, 255});
        NAMES.put("mediumseagreen", new int[]{60, 179, 113, 255});
        NAMES.put("mediumslateblue", new int[]{123, 104, 238, 255});
        int[] nArray24 = new int[4];
        nArray24[1] = 250;
        nArray24[2] = 154;
        nArray24[3] = 255;
        NAMES.put("mediumspringgreen", nArray24);
        NAMES.put("mediumturquoise", new int[]{72, 209, 204, 255});
        NAMES.put("mediumvioletred", new int[]{199, 21, 133, 255});
        NAMES.put("midnightblue", new int[]{25, 25, 112, 255});
        NAMES.put("mintcream", new int[]{245, 255, 250, 255});
        NAMES.put("mistyrose", new int[]{255, 228, 225, 255});
        NAMES.put("moccasin", new int[]{255, 228, 181, 255});
        NAMES.put("navajowhite", new int[]{255, 222, 173, 255});
        int[] nArray25 = new int[4];
        nArray25[2] = 128;
        nArray25[3] = 255;
        NAMES.put("navy", nArray25);
        NAMES.put("oldlace", new int[]{253, 245, 230, 255});
        int[] nArray26 = new int[4];
        nArray26[0] = 128;
        nArray26[1] = 128;
        nArray26[3] = 255;
        NAMES.put("olive", nArray26);
        NAMES.put("olivedrab", new int[]{107, 142, 35, 255});
        int[] nArray27 = new int[4];
        nArray27[0] = 255;
        nArray27[1] = 165;
        nArray27[3] = 255;
        NAMES.put("orange", nArray27);
        int[] nArray28 = new int[4];
        nArray28[0] = 255;
        nArray28[1] = 69;
        nArray28[3] = 255;
        NAMES.put("orangered", nArray28);
        NAMES.put("orchid", new int[]{218, 112, 214, 255});
        NAMES.put("palegoldenrod", new int[]{238, 232, 170, 255});
        NAMES.put("palegreen", new int[]{152, 251, 152, 255});
        NAMES.put("paleturquoise", new int[]{175, 238, 238, 255});
        NAMES.put("palevioletred", new int[]{219, 112, 147, 255});
        NAMES.put("papayawhip", new int[]{255, 239, 213, 255});
        NAMES.put("peachpuff", new int[]{255, 218, 185, 255});
        NAMES.put("peru", new int[]{205, 133, 63, 255});
        NAMES.put("pink", new int[]{255, 192, 203, 255});
        NAMES.put("plum", new int[]{221, 160, 221, 255});
        NAMES.put("powderblue", new int[]{176, 224, 230, 255});
        int[] nArray29 = new int[4];
        nArray29[0] = 128;
        nArray29[2] = 128;
        nArray29[3] = 255;
        NAMES.put("purple", nArray29);
        int[] nArray30 = new int[4];
        nArray30[0] = 255;
        nArray30[3] = 255;
        NAMES.put("red", nArray30);
        NAMES.put("rosybrown", new int[]{188, 143, 143, 255});
        NAMES.put("royalblue", new int[]{65, 105, 225, 255});
        NAMES.put("saddlebrown", new int[]{139, 69, 19, 255});
        NAMES.put("salmon", new int[]{250, 128, 114, 255});
        NAMES.put("sandybrown", new int[]{244, 164, 96, 255});
        NAMES.put("seagreen", new int[]{46, 139, 87, 255});
        NAMES.put("seashell", new int[]{255, 245, 238, 255});
        NAMES.put("sienna", new int[]{160, 82, 45, 255});
        NAMES.put("silver", new int[]{192, 192, 192, 255});
        NAMES.put("skyblue", new int[]{135, 206, 235, 255});
        NAMES.put("slateblue", new int[]{106, 90, 205, 255});
        NAMES.put("slategray", new int[]{112, 128, 144, 255});
        NAMES.put("snow", new int[]{255, 250, 250, 255});
        int[] nArray31 = new int[4];
        nArray31[1] = 255;
        nArray31[2] = 127;
        nArray31[3] = 255;
        NAMES.put("springgreen", nArray31);
        NAMES.put("steelblue", new int[]{70, 130, 180, 255});
        NAMES.put("tan", new int[]{210, 180, 140, 255});
        int[] nArray32 = new int[4];
        nArray32[1] = 128;
        nArray32[2] = 128;
        nArray32[3] = 255;
        NAMES.put("teal", nArray32);
        NAMES.put("thistle", new int[]{216, 191, 216, 255});
        NAMES.put("tomato", new int[]{255, 99, 71, 255});
        NAMES.put("transparent", new int[4]);
        NAMES.put("turquoise", new int[]{64, 224, 208, 255});
        NAMES.put("violet", new int[]{238, 130, 238, 255});
        NAMES.put("wheat", new int[]{245, 222, 179, 255});
        NAMES.put("white", new int[]{255, 255, 255, 255});
        NAMES.put("whitesmoke", new int[]{245, 245, 245, 255});
        int[] nArray33 = new int[4];
        nArray33[0] = 255;
        nArray33[1] = 255;
        nArray33[3] = 255;
        NAMES.put("yellow", nArray33);
        NAMES.put("yellowgreen", new int[]{154, 205, 50, 255});
    }

    private static boolean missingHashColorFormat(String colStr) {
        int len = colStr.length();
        if (len == 3 || len == 6) {
            String match = "[0-9a-f]{" + len + "}";
            return colStr.matches(match);
        }
        return false;
    }

    public static BaseColor getRGBColor(String name) throws IllegalArgumentException {
        int[] nArray = new int[4];
        nArray[3] = 255;
        int[] c = nArray;
        name = name.toLowerCase();
        boolean colorStrWithoutHash = WebColors.missingHashColorFormat(name);
        if (name.startsWith("#") || colorStrWithoutHash) {
            if (!colorStrWithoutHash) {
                name = name.substring(1);
            }
            if (name.length() == 3) {
                String s = name.substring(0, 1);
                c[0] = Integer.parseInt(String.valueOf(s) + s, 16);
                String s2 = name.substring(1, 2);
                c[1] = Integer.parseInt(String.valueOf(s2) + s2, 16);
                String s3 = name.substring(2);
                c[2] = Integer.parseInt(String.valueOf(s3) + s3, 16);
                return new BaseColor(c[0], c[1], c[2], c[3]);
            }
            if (name.length() == 6) {
                c[0] = Integer.parseInt(name.substring(0, 2), 16);
                c[1] = Integer.parseInt(name.substring(2, 4), 16);
                c[2] = Integer.parseInt(name.substring(4), 16);
                return new BaseColor(c[0], c[1], c[2], c[3]);
            }
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("unknown.color.format.must.be.rgb.or.rrggbb", new Object[0]));
        }
        if (name.startsWith("rgb(")) {
            StringTokenizer tok = new StringTokenizer(name, "rgb(), \t\r\n\f");
            int k = 0;
            while (k < 3) {
                String v = tok.nextToken();
                c[k] = v.endsWith("%") ? Integer.parseInt(v.substring(0, v.length() - 1)) * 255 / 100 : Integer.parseInt(v);
                if (c[k] < 0) {
                    c[k] = 0;
                } else if (c[k] > 255) {
                    c[k] = 255;
                }
                ++k;
            }
            return new BaseColor(c[0], c[1], c[2], c[3]);
        }
        if (!NAMES.containsKey(name)) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("color.not.found", name));
        }
        c = (int[])NAMES.get(name);
        return new BaseColor(c[0], c[1], c[2], c[3]);
    }
}

