/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text;

import com.KGitextpdf.text.pdf.draw.DrawInterface;

public class TabStop {
    protected float position;
    protected Alignment alignment = Alignment.LEFT;
    protected DrawInterface leader;
    protected char anchorChar = (char)46;

    public static TabStop newInstance(float currentPosition, float tabInterval) {
        currentPosition = (float)Math.round(currentPosition * 1000.0f) / 1000.0f;
        tabInterval = (float)Math.round(tabInterval * 1000.0f) / 1000.0f;
        TabStop tabStop = new TabStop(currentPosition + tabInterval - currentPosition % tabInterval);
        return tabStop;
    }

    public TabStop(float position) {
        this(position, Alignment.LEFT);
    }

    public TabStop(float position, DrawInterface leader) {
        this(position, leader, Alignment.LEFT);
    }

    public TabStop(float position, Alignment alignment) {
        this(position, null, alignment);
    }

    public TabStop(float position, Alignment alignment, char anchorChar) {
        this(position, null, alignment, anchorChar);
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment) {
        this(position, leader, alignment, '.');
    }

    public TabStop(float position, DrawInterface leader, Alignment alignment, char anchorChar) {
        this.position = position;
        this.leader = leader;
        this.alignment = alignment;
        this.anchorChar = anchorChar;
    }

    public TabStop(TabStop tabStop) {
        this(tabStop.getPosition(), tabStop.getLeader(), tabStop.getAlignment(), tabStop.getAnchorChar());
    }

    public float getPosition() {
        return this.position;
    }

    public void setPosition(float position) {
        this.position = position;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public DrawInterface getLeader() {
        return this.leader;
    }

    public void setLeader(DrawInterface leader) {
        this.leader = leader;
    }

    public char getAnchorChar() {
        return this.anchorChar;
    }

    public void setAnchorChar(char anchorChar) {
        this.anchorChar = anchorChar;
    }

    public float getPosition(float tabPosition, float currentPosition, float anchorPosition) {
        float newPosition = this.position;
        float textWidth = currentPosition - tabPosition;
        switch (this.alignment) {
            case RIGHT: {
                if (tabPosition + textWidth < this.position) {
                    newPosition = this.position - textWidth;
                    break;
                }
                newPosition = tabPosition;
                break;
            }
            case CENTER: {
                if (tabPosition + textWidth / 2.0f < this.position) {
                    newPosition = this.position - textWidth / 2.0f;
                    break;
                }
                newPosition = tabPosition;
                break;
            }
            case ANCHOR: {
                if (!Float.isNaN(anchorPosition)) {
                    if (anchorPosition < this.position) {
                        newPosition = this.position - (anchorPosition - tabPosition);
                        break;
                    }
                    newPosition = tabPosition;
                    break;
                }
                newPosition = tabPosition + textWidth < this.position ? this.position - textWidth : tabPosition;
            }
        }
        return newPosition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        LEFT,
        RIGHT,
        CENTER,
        ANCHOR;

    }
}

