/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text;

import com.KGitextpdf.text.BadElementException;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.Utilities;
import com.KGitextpdf.text.error_messages.MessageLocalization;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jpeg2000
extends Image {
    public static final int JP2_JP = 1783636000;
    public static final int JP2_IHDR = 1768449138;
    public static final int JPIP_JPIP = 1785751920;
    public static final int JP2_FTYP = 1718909296;
    public static final int JP2_JP2H = 1785737832;
    public static final int JP2_COLR = 1668246642;
    public static final int JP2_JP2C = 1785737827;
    public static final int JP2_URL = 1970433056;
    public static final int JP2_DBTL = 1685348972;
    public static final int JP2_BPCC = 1651532643;
    public static final int JP2_JP2 = 1785737760;
    InputStream inp;
    int boxLength;
    int boxType;
    int numOfComps;
    ArrayList<ColorSpecBox> colorSpecBoxes = null;
    boolean isJp2 = false;
    byte[] bpcBoxData;

    Jpeg2000(Image image) {
        super(image);
        if (image instanceof Jpeg2000) {
            Jpeg2000 jpeg2000 = (Jpeg2000)image;
            this.numOfComps = jpeg2000.numOfComps;
            if (this.colorSpecBoxes != null) {
                this.colorSpecBoxes = (ArrayList)jpeg2000.colorSpecBoxes.clone();
            }
            this.isJp2 = jpeg2000.isJp2;
            if (this.bpcBoxData != null) {
                this.bpcBoxData = (byte[])jpeg2000.bpcBoxData.clone();
            }
        }
    }

    public Jpeg2000(URL url) throws BadElementException, IOException {
        super(url);
        this.processParameters();
    }

    public Jpeg2000(byte[] img) throws BadElementException, IOException {
        super((URL)null);
        this.rawData = img;
        this.originalData = img;
        this.processParameters();
    }

    public Jpeg2000(byte[] img, float width, float height) throws BadElementException, IOException {
        this(img);
        this.scaledWidth = width;
        this.scaledHeight = height;
    }

    private int cio_read(int n) throws IOException {
        int v = 0;
        int i = n - 1;
        while (i >= 0) {
            v += this.inp.read() << (i << 3);
            --i;
        }
        return v;
    }

    public void jp2_read_boxhdr() throws IOException {
        this.boxLength = this.cio_read(4);
        this.boxType = this.cio_read(4);
        if (this.boxLength == 1) {
            if (this.cio_read(4) != 0) {
                throw new IOException(MessageLocalization.getComposedMessage("cannot.handle.box.sizes.higher.than.2.32", new Object[0]));
            }
            this.boxLength = this.cio_read(4);
            if (this.boxLength == 0) {
                throw new IOException(MessageLocalization.getComposedMessage("unsupported.box.size.eq.eq.0", new Object[0]));
            }
        } else if (this.boxLength == 0) {
            throw new ZeroBoxSizeException(MessageLocalization.getComposedMessage("unsupported.box.size.eq.eq.0", new Object[0]));
        }
    }

    private void processParameters() throws IOException {
        block23: {
            this.type = 33;
            this.originalType = 8;
            this.inp = null;
            try {
                this.inp = this.rawData == null ? this.url.openStream() : new ByteArrayInputStream(this.rawData);
                this.boxLength = this.cio_read(4);
                if (this.boxLength == 12) {
                    this.isJp2 = true;
                    this.boxType = this.cio_read(4);
                    if (1783636000 != this.boxType) {
                        throw new IOException(MessageLocalization.getComposedMessage("expected.jp.marker", new Object[0]));
                    }
                    if (218793738 != this.cio_read(4)) {
                        throw new IOException(MessageLocalization.getComposedMessage("error.with.jp.marker", new Object[0]));
                    }
                    this.jp2_read_boxhdr();
                    if (1718909296 != this.boxType) {
                        throw new IOException(MessageLocalization.getComposedMessage("expected.ftyp.marker", new Object[0]));
                    }
                    Utilities.skip(this.inp, this.boxLength - 8);
                    this.jp2_read_boxhdr();
                    do {
                        if (1785737832 == this.boxType) continue;
                        if (this.boxType == 1785737827) {
                            throw new IOException(MessageLocalization.getComposedMessage("expected.jp2h.marker", new Object[0]));
                        }
                        Utilities.skip(this.inp, this.boxLength - 8);
                        this.jp2_read_boxhdr();
                    } while (1785737832 != this.boxType);
                    this.jp2_read_boxhdr();
                    if (1768449138 != this.boxType) {
                        throw new IOException(MessageLocalization.getComposedMessage("expected.ihdr.marker", new Object[0]));
                    }
                    this.scaledHeight = this.cio_read(4);
                    this.setTop(this.scaledHeight);
                    this.scaledWidth = this.cio_read(4);
                    this.setRight(this.scaledWidth);
                    this.numOfComps = this.cio_read(2);
                    this.bpc = -1;
                    this.bpc = this.cio_read(1);
                    Utilities.skip(this.inp, 3);
                    this.jp2_read_boxhdr();
                    if (this.boxType == 1651532643) {
                        this.bpcBoxData = new byte[this.boxLength - 8];
                        this.inp.read(this.bpcBoxData, 0, this.boxLength - 8);
                    } else if (this.boxType == 1668246642) {
                        do {
                            if (this.colorSpecBoxes == null) {
                                this.colorSpecBoxes = new ArrayList();
                            }
                            this.colorSpecBoxes.add(this.jp2_read_colr());
                            try {
                                this.jp2_read_boxhdr();
                            }
                            catch (ZeroBoxSizeException zeroBoxSizeException) {
                                // empty catch block
                            }
                        } while (1668246642 == this.boxType);
                    }
                    break block23;
                }
                if (this.boxLength == -11534511) {
                    Utilities.skip(this.inp, 4);
                    int x1 = this.cio_read(4);
                    int y1 = this.cio_read(4);
                    int x0 = this.cio_read(4);
                    int y0 = this.cio_read(4);
                    Utilities.skip(this.inp, 16);
                    this.colorspace = this.cio_read(2);
                    this.bpc = 8;
                    this.scaledHeight = y1 - y0;
                    this.setTop(this.scaledHeight);
                    this.scaledWidth = x1 - x0;
                    this.setRight(this.scaledWidth);
                    break block23;
                }
                throw new IOException(MessageLocalization.getComposedMessage("not.a.valid.jpeg2000.file", new Object[0]));
            }
            finally {
                if (this.inp != null) {
                    try {
                        this.inp.close();
                    }
                    catch (Exception exception) {}
                    this.inp = null;
                }
            }
        }
        this.plainWidth = this.getWidth();
        this.plainHeight = this.getHeight();
    }

    private ColorSpecBox jp2_read_colr() throws IOException {
        int readBytes = 8;
        ColorSpecBox colr = new ColorSpecBox();
        int i = 0;
        while (i < 3) {
            colr.add(this.cio_read(1));
            ++readBytes;
            ++i;
        }
        if (colr.getMeth() == 1) {
            colr.add(this.cio_read(4));
            readBytes += 4;
        } else {
            colr.add(0);
        }
        if (this.boxLength - readBytes > 0) {
            byte[] colorProfile = new byte[this.boxLength - readBytes];
            this.inp.read(colorProfile, 0, this.boxLength - readBytes);
            colr.setColorProfile(colorProfile);
        }
        return colr;
    }

    public int getNumOfComps() {
        return this.numOfComps;
    }

    public byte[] getBpcBoxData() {
        return this.bpcBoxData;
    }

    public ArrayList<ColorSpecBox> getColorSpecBoxes() {
        return this.colorSpecBoxes;
    }

    public boolean isJp2() {
        return this.isJp2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColorSpecBox
    extends ArrayList<Integer> {
        private byte[] colorProfile;

        public int getMeth() {
            return (Integer)this.get(0);
        }

        public int getPrec() {
            return (Integer)this.get(1);
        }

        public int getApprox() {
            return (Integer)this.get(2);
        }

        public int getEnumCs() {
            return (Integer)this.get(3);
        }

        public byte[] getColorProfile() {
            return this.colorProfile;
        }

        void setColorProfile(byte[] colorProfile) {
            this.colorProfile = colorProfile;
        }
    }

    private class ZeroBoxSizeException
    extends IOException {
        public ZeroBoxSizeException() {
        }

        public ZeroBoxSizeException(String s) {
            super(s);
        }
    }
}

