/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.awt;

import com.KGitextpdf.awt.FontMapper;
import com.KGitextpdf.text.ExceptionConverter;
import com.KGitextpdf.text.pdf.BaseFont;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFontMapper
implements FontMapper {
    private HashMap<String, String> aliases = new HashMap();
    private HashMap<String, BaseFontParameters> mapper = new HashMap();

    @Override
    public BaseFont awtToPdf(Font font) {
        try {
            BaseFontParameters p = this.getBaseFontParameters(font.getFontName());
            if (p != null) {
                return BaseFont.createFont(p.fontName, p.encoding, p.embedded, p.cached, p.ttfAfm, p.pfb);
            }
            String fontKey = null;
            String logicalName = font.getName();
            fontKey = logicalName.equalsIgnoreCase("DialogInput") || logicalName.equalsIgnoreCase("Monospaced") || logicalName.equalsIgnoreCase("Courier") ? (font.isItalic() ? (font.isBold() ? "Courier-BoldOblique" : "Courier-Oblique") : (font.isBold() ? "Courier-Bold" : "Courier")) : (logicalName.equalsIgnoreCase("Serif") || logicalName.equalsIgnoreCase("TimesRoman") ? (font.isItalic() ? (font.isBold() ? "Times-BoldItalic" : "Times-Italic") : (font.isBold() ? "Times-Bold" : "Times-Roman")) : (font.isItalic() ? (font.isBold() ? "Helvetica-BoldOblique" : "Helvetica-Oblique") : (font.isBold() ? "Helvetica-Bold" : "Helvetica")));
            return BaseFont.createFont(fontKey, "Cp1252", false);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    @Override
    public Font pdfToAwt(BaseFont font, int size) {
        String[][] names = font.getFullFontName();
        if (names.length == 1) {
            return new Font(names[0][3], 0, size);
        }
        String name10 = null;
        String name3x = null;
        int k = 0;
        while (k < names.length) {
            String[] name = names[k];
            if (name[0].equals("1") && name[1].equals("0")) {
                name10 = name[3];
            } else if (name[2].equals("1033")) {
                name3x = name[3];
                break;
            }
            ++k;
        }
        String finalName = name3x;
        if (finalName == null) {
            finalName = name10;
        }
        if (finalName == null) {
            finalName = names[0][3];
        }
        return new Font(finalName, 0, size);
    }

    public void putName(String awtName, BaseFontParameters parameters) {
        this.mapper.put(awtName, parameters);
    }

    public void putAlias(String alias, String awtName) {
        this.aliases.put(alias, awtName);
    }

    public BaseFontParameters getBaseFontParameters(String name) {
        String alias = this.aliases.get(name);
        if (alias == null) {
            return this.mapper.get(name);
        }
        BaseFontParameters p = this.mapper.get(alias);
        if (p == null) {
            return this.mapper.get(name);
        }
        return p;
    }

    public void insertNames(Object[] allNames, String path) {
        String[][] names = (String[][])allNames[2];
        String main = null;
        int k = 0;
        while (k < names.length) {
            String[] name = names[k];
            if (name[2].equals("1033")) {
                main = name[3];
                break;
            }
            ++k;
        }
        if (main == null) {
            main = names[0][3];
        }
        BaseFontParameters p = new BaseFontParameters(path);
        this.mapper.put(main, p);
        int k2 = 0;
        while (k2 < names.length) {
            this.aliases.put(names[k2][3], main);
            ++k2;
        }
        this.aliases.put((String)allNames[0], main);
    }

    public int insertFile(File file) {
        String name;
        block5: {
            name = file.getPath().toLowerCase();
            if (!name.endsWith(".ttf") && !name.endsWith(".otf") && !name.endsWith(".afm")) break block5;
            Object[] allNames = BaseFont.getAllFontNames(file.getPath(), "Cp1252", null);
            this.insertNames(allNames, file.getPath());
            return 1;
        }
        try {
            if (name.endsWith(".ttc")) {
                String[] ttcs = BaseFont.enumerateTTCNames(file.getPath());
                int j = 0;
                while (j < ttcs.length) {
                    String nt = String.valueOf(file.getPath()) + "," + j;
                    Object[] allNames = BaseFont.getAllFontNames(nt, "Cp1252", null);
                    this.insertNames(allNames, nt);
                    ++j;
                }
                return 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public int insertDirectory(String dir) {
        File file = new File(dir);
        if (!file.exists() || !file.isDirectory()) {
            return 0;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return 0;
        }
        int count = 0;
        int k = 0;
        while (k < files.length) {
            count += this.insertFile(files[k]);
            ++k;
        }
        return count;
    }

    public HashMap<String, BaseFontParameters> getMapper() {
        return this.mapper;
    }

    public HashMap<String, String> getAliases() {
        return this.aliases;
    }

    public static class BaseFontParameters {
        public String fontName;
        public String encoding;
        public boolean embedded;
        public boolean cached;
        public byte[] ttfAfm;
        public byte[] pfb;

        public BaseFontParameters(String fontName) {
            this.fontName = fontName;
            this.encoding = "Cp1252";
            this.embedded = true;
            this.cached = true;
        }
    }
}

