/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.reader;

import com.jpattern.orm.exception.OrmNotUniqueResultManyResultsException;
import com.jpattern.orm.exception.OrmNotUniqueResultNoResultException;
import com.jpattern.orm.session.ResultSetReader;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LongResultSetReader
implements ResultSetReader<Long> {
    @Override
    public Long read(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            long result = resultSet.getLong(1);
            if (resultSet.next()) {
                throw new OrmNotUniqueResultManyResultsException("The query execution returned a number of rows higher than 1");
            }
            return result;
        }
        throw new OrmNotUniqueResultNoResultException("The query execution has returned zero rows. One row was expected");
    }
}

