/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.reader;

import com.jpattern.orm.exception.OrmNotUniqueResultManyResultsException;
import com.jpattern.orm.exception.OrmNotUniqueResultNoResultException;
import com.jpattern.orm.session.ResultSetReader;
import java.sql.ResultSet;
import java.sql.SQLException;

public class FloatResultSetReader
implements ResultSetReader<Float> {
    @Override
    public Float read(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            Float result = Float.valueOf(resultSet.getFloat(1));
            if (resultSet.next()) {
                throw new OrmNotUniqueResultManyResultsException("The query execution returned a number of rows higher than 1");
            }
            return result;
        }
        throw new OrmNotUniqueResultNoResultException("The query execution has returned zero rows. One row was expected");
    }
}

