/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.reader;

import com.jpattern.orm.exception.OrmNotUniqueResultManyResultsException;
import com.jpattern.orm.exception.OrmNotUniqueResultNoResultException;
import com.jpattern.orm.session.ResultSetReader;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ArrayResultSetReader
implements ResultSetReader<Object[]> {
    @Override
    public Object[] read(ResultSet resultSet) throws SQLException {
        int columnNumber = resultSet.getMetaData().getColumnCount();
        if (resultSet.next()) {
            Object[] result = new Object[columnNumber];
            for (int i = 0; i < columnNumber; ++i) {
                result[i] = resultSet.getObject(i + 1);
            }
            if (resultSet.next()) {
                throw new OrmNotUniqueResultManyResultsException("The query execution returned a number of rows higher than 1");
            }
            return result;
        }
        throw new OrmNotUniqueResultNoResultException("The query execution has returned zero rows. One row was expected");
    }
}

