/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.datasource.exception;

import com.jpattern.orm.exception.sql.OrmSqlBadGrammarException;
import com.jpattern.orm.exception.sql.OrmSqlConcurrencyFailureException;
import com.jpattern.orm.exception.sql.OrmSqlDataAccessResourceFailureException;
import com.jpattern.orm.exception.sql.OrmSqlDataIntegrityViolationException;
import com.jpattern.orm.exception.sql.OrmSqlException;
import com.jpattern.orm.exception.sql.OrmSqlTransientDataAccessResourceException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class SpringBasedSQLStateSQLExceptionTranslator {
    private static final Set<String> BAD_SQL_GRAMMAR_CODES = new HashSet<String>(8);
    private static final Set<String> DATA_INTEGRITY_VIOLATION_CODES = new HashSet<String>(8);
    private static final Set<String> DATA_ACCESS_RESOURCE_FAILURE_CODES = new HashSet<String>(8);
    private static final Set<String> TRANSIENT_DATA_ACCESS_RESOURCE_CODES = new HashSet<String>(8);
    private static final Set<String> CONCURRENCY_FAILURE_CODES = new HashSet<String>(4);

    private SpringBasedSQLStateSQLExceptionTranslator() {
    }

    public static OrmSqlException doTranslate(String task, String sql, SQLException ex) {
        String sqlState = SpringBasedSQLStateSQLExceptionTranslator.getSqlState(ex);
        if (sqlState != null && sqlState.length() >= 2) {
            String classCode = sqlState.substring(0, 2);
            if (BAD_SQL_GRAMMAR_CODES.contains(classCode)) {
                return new OrmSqlBadGrammarException(SpringBasedSQLStateSQLExceptionTranslator.buildMessage(task, sql, ex), ex);
            }
            if (DATA_INTEGRITY_VIOLATION_CODES.contains(classCode)) {
                return new OrmSqlDataIntegrityViolationException(SpringBasedSQLStateSQLExceptionTranslator.buildMessage(task, sql, ex), ex);
            }
            if (DATA_ACCESS_RESOURCE_FAILURE_CODES.contains(classCode)) {
                return new OrmSqlDataAccessResourceFailureException(SpringBasedSQLStateSQLExceptionTranslator.buildMessage(task, sql, ex), ex);
            }
            if (TRANSIENT_DATA_ACCESS_RESOURCE_CODES.contains(classCode)) {
                return new OrmSqlTransientDataAccessResourceException(SpringBasedSQLStateSQLExceptionTranslator.buildMessage(task, sql, ex), ex);
            }
            if (CONCURRENCY_FAILURE_CODES.contains(classCode)) {
                return new OrmSqlConcurrencyFailureException(SpringBasedSQLStateSQLExceptionTranslator.buildMessage(task, sql, ex), ex);
            }
        }
        return new OrmSqlException(SpringBasedSQLStateSQLExceptionTranslator.buildMessage(task, sql, ex), ex);
    }

    private static String getSqlState(SQLException ex) {
        SQLException nestedEx;
        String sqlState = ex.getSQLState();
        if (sqlState == null && (nestedEx = ex.getNextException()) != null) {
            sqlState = nestedEx.getSQLState();
        }
        return sqlState;
    }

    private static String buildMessage(String task, String sql, SQLException ex) {
        return task + "; SQL [" + sql + "]; " + ex.getMessage();
    }

    static {
        BAD_SQL_GRAMMAR_CODES.add("07");
        BAD_SQL_GRAMMAR_CODES.add("21");
        BAD_SQL_GRAMMAR_CODES.add("2A");
        BAD_SQL_GRAMMAR_CODES.add("37");
        BAD_SQL_GRAMMAR_CODES.add("42");
        BAD_SQL_GRAMMAR_CODES.add("65");
        BAD_SQL_GRAMMAR_CODES.add("S0");
        DATA_INTEGRITY_VIOLATION_CODES.add("01");
        DATA_INTEGRITY_VIOLATION_CODES.add("02");
        DATA_INTEGRITY_VIOLATION_CODES.add("22");
        DATA_INTEGRITY_VIOLATION_CODES.add("23");
        DATA_INTEGRITY_VIOLATION_CODES.add("27");
        DATA_INTEGRITY_VIOLATION_CODES.add("44");
        DATA_ACCESS_RESOURCE_FAILURE_CODES.add("08");
        DATA_ACCESS_RESOURCE_FAILURE_CODES.add("53");
        DATA_ACCESS_RESOURCE_FAILURE_CODES.add("54");
        DATA_ACCESS_RESOURCE_FAILURE_CODES.add("57");
        DATA_ACCESS_RESOURCE_FAILURE_CODES.add("58");
        TRANSIENT_DATA_ACCESS_RESOURCE_CODES.add("JW");
        TRANSIENT_DATA_ACCESS_RESOURCE_CODES.add("JZ");
        TRANSIENT_DATA_ACCESS_RESOURCE_CODES.add("S1");
        CONCURRENCY_FAILURE_CODES.add("40");
        CONCURRENCY_FAILURE_CODES.add("61");
    }
}

