/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.datasource;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmRollbackException;
import com.jpattern.orm.session.datasource.DataSourceSessionProvider;
import com.jpattern.orm.session.datasource.IConnection;
import com.jpattern.orm.session.datasource.IConnectionCaller;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.transaction.TransactionDefinition;
import com.jpattern.orm.transaction.TransactionIsolation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceTransaction
implements Transaction,
IConnectionCaller {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IConnection conn;
    private boolean isClosed = false;
    private boolean rollbackOnly = false;

    public DataSourceTransaction(DataSourceSessionProvider dataSourceSessionProvider, TransactionDefinition transactionDefinition) {
        this.conn = dataSourceSessionProvider.getConnection(transactionDefinition.isReadOnly(), this);
        if (transactionDefinition.getIsolationLevel() != TransactionIsolation.DEFAULT) {
            this.conn.setTransactionIsolation(transactionDefinition.getIsolationLevel().getTransactionIsolation());
        }
    }

    @Override
    public void setRollbackOnly() throws OrmException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Transaction sets rollback only");
        }
        this.rollbackOnly = true;
        this.conn.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws OrmException {
        this.setRollbackOnly();
        try {
            if (!this.isClosed && !this.conn.isClosed()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Rollback called");
                }
                this.conn.rollback();
            }
        }
        finally {
            this.conn.close(this);
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws OrmException, OrmRollbackException {
        if (this.rollbackOnly) {
            this.rollback();
            return;
        }
        try {
            if (!this.isClosed && !this.conn.isClosed()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Commit called");
                }
                this.conn.commit();
            }
        }
        finally {
            this.conn.close(this);
            this.isClosed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }
}

