/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.datasource;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.sql.OrmSqlException;
import com.jpattern.orm.session.BatchPreparedStatementSetter;
import com.jpattern.orm.session.GeneratedKeyReader;
import com.jpattern.orm.session.PreparedStatementSetter;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.SqlPerformerStrategy;
import com.jpattern.orm.session.datasource.DataSourceConnection;
import com.jpattern.orm.session.datasource.DataSourceSessionProvider;
import com.jpattern.orm.session.datasource.IConnectionCaller;
import com.jpattern.orm.session.datasource.IStatement;
import com.jpattern.orm.session.datasource.exception.SpringBasedSQLStateSQLExceptionTranslator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceSqlPerformerStrategy
implements SqlPerformerStrategy,
IConnectionCaller {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DataSourceSessionProvider dataSourceSessionProvider;

    public DataSourceSqlPerformerStrategy(DataSourceSessionProvider dataSourceSessionProvider) {
        this.dataSourceSessionProvider = dataSourceSessionProvider;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(String sql, int timeout) throws OrmException {
        this.logger.debug("Method called");
        PreparedStatement preparedStatement = null;
        DataSourceConnection conn = this.dataSourceSessionProvider.getConnection(false, this);
        try {
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setQueryTimeout(timeout);
            preparedStatement.execute();
            conn.commit();
            return;
        }
        catch (Exception e) {
            conn.rollback();
            throw this.translateException("execute", sql, e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception e) {
                throw this.translateException("execute", sql, e);
            }
            finally {
                conn.close(this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T query(String sql, int timeout, int maxRows, PreparedStatementSetter pss, ResultSetReader<T> rse) throws OrmException {
        this.logger.debug("Method called");
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        DataSourceConnection conn = this.dataSourceSessionProvider.getConnection(true, this);
        try {
            preparedStatement = conn.prepareStatement(sql);
            pss.set(preparedStatement);
            preparedStatement.setMaxRows(maxRows);
            preparedStatement.setQueryTimeout(timeout);
            resultSet = preparedStatement.executeQuery();
            T t = rse.read(resultSet);
            return t;
        }
        catch (Exception e) {
            throw this.translateException("query", sql, e);
        }
        finally {
            try {
                if (resultSet != null && !resultSet.isClosed()) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception e) {
                throw this.translateException("query", sql, e);
            }
            finally {
                conn.close(this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int update(String sql, int timeout, PreparedStatementSetter pss) throws OrmException {
        this.logger.debug("Method called");
        DataSourceConnection conn = this.dataSourceSessionProvider.getConnection(false, this);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setQueryTimeout(timeout);
            pss.set(preparedStatement);
            int result = preparedStatement.executeUpdate();
            conn.commit();
            int n = result;
            return n;
        }
        catch (Exception e) {
            conn.rollback();
            throw this.translateException("update", sql, e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception e) {
                throw this.translateException("update", sql, e);
            }
            finally {
                conn.close(this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int update(String sql, int timeout, GeneratedKeyReader generatedKeyExtractor, PreparedStatementSetter pss) throws OrmException {
        this.logger.debug("Method called");
        DataSourceConnection conn = this.dataSourceSessionProvider.getConnection(false, this);
        ResultSet generatedKeyResultSet = null;
        PreparedStatement preparedStatement = null;
        int result = 0;
        try {
            preparedStatement = conn.prepareStatement(sql, generatedKeyExtractor.generatedColumnNames());
            preparedStatement.setQueryTimeout(timeout);
            pss.set(preparedStatement);
            result = preparedStatement.executeUpdate();
            generatedKeyResultSet = preparedStatement.getGeneratedKeys();
            generatedKeyExtractor.read(generatedKeyResultSet);
            conn.commit();
            int n = result;
            return n;
        }
        catch (Exception e) {
            conn.rollback();
            throw this.translateException("update", sql, e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (generatedKeyResultSet != null && !generatedKeyResultSet.isClosed()) {
                    generatedKeyResultSet.close();
                }
            }
            catch (Exception e) {
                throw this.translateException("update", sql, e);
            }
            finally {
                conn.close(this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] batchUpdate(List<String> sqls, int timeout) throws OrmException {
        this.logger.debug("Method called");
        DataSourceConnection conn = this.dataSourceSessionProvider.getConnection(false, this);
        IStatement statement = null;
        try {
            statement = conn.createStatement();
            statement.setQueryTimeout(timeout);
            for (String sql : sqls) {
                statement.addBatch(sql);
            }
            int[] result = statement.executeBatch();
            conn.commit();
            int[] nArray = result;
            return nArray;
        }
        catch (Exception e) {
            conn.rollback();
            throw this.translateException("batchUpdate", "", e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                throw this.translateException("batchUpdate", "", e);
            }
            finally {
                conn.close(this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] batchUpdate(String sql, List<Object[]> args, int timeout) throws OrmException {
        this.logger.debug("Method called");
        DataSourceConnection conn = this.dataSourceSessionProvider.getConnection(false, this);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setQueryTimeout(timeout);
            for (Object[] arg : args) {
                int i = 0;
                for (Object value : arg) {
                    preparedStatement.setObject(++i, value);
                }
                preparedStatement.addBatch();
            }
            int[] result = preparedStatement.executeBatch();
            conn.commit();
            int[] nArray = result;
            return nArray;
        }
        catch (Exception e) {
            conn.rollback();
            throw this.translateException("batchUpdate", sql, e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception e) {
                throw this.translateException("batchUpdate", sql, e);
            }
            finally {
                conn.close(this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] batchUpdate(String sql, BatchPreparedStatementSetter psc, int timeout) throws OrmException {
        this.logger.debug("Method called");
        DataSourceConnection conn = this.dataSourceSessionProvider.getConnection(false, this);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement(sql);
            preparedStatement.setQueryTimeout(timeout);
            for (int i = 0; i < psc.getBatchSize(); ++i) {
                psc.set(preparedStatement, i);
                preparedStatement.addBatch();
            }
            int[] result = preparedStatement.executeBatch();
            conn.commit();
            int[] nArray = result;
            return nArray;
        }
        catch (Exception e) {
            conn.rollback();
            throw this.translateException("batchUpdate", sql, e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception e) {
                throw this.translateException("batchUpdate", sql, e);
            }
            finally {
                conn.close(this);
            }
        }
    }

    private OrmException translateException(String task, String sql, Exception ex) {
        if (ex instanceof OrmException) {
            return (OrmException)ex;
        }
        if (ex instanceof SQLException) {
            return SpringBasedSQLStateSQLExceptionTranslator.doTranslate(task, sql, (SQLException)ex);
        }
        return new OrmSqlException(ex);
    }
}

