/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.datasource;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.SessionStrategy;
import com.jpattern.orm.session.SqlPerformerStrategy;
import com.jpattern.orm.session.datasource.DataSourceSessionProvider;
import com.jpattern.orm.session.datasource.DataSourceSqlPerformerStrategy;
import com.jpattern.orm.session.datasource.DataSourceTransaction;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.transaction.TransactionDefinition;

public class DataSourceSessionStrategy
implements SessionStrategy {
    private final DataSourceSessionProvider dataSourceSessionProvider;

    public DataSourceSessionStrategy(DataSourceSessionProvider dataSourceSessionProvider) {
        this.dataSourceSessionProvider = dataSourceSessionProvider;
    }

    @Override
    public Transaction getTransaction(TransactionDefinition transactionDefinition) throws OrmException {
        return new DataSourceTransaction(this.dataSourceSessionProvider, transactionDefinition);
    }

    @Override
    public SqlPerformerStrategy sqlPerformerStrategy() throws OrmException {
        return new DataSourceSqlPerformerStrategy(this.dataSourceSessionProvider);
    }
}

