/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session.datasource;

import com.jpattern.orm.session.SessionProvider;
import com.jpattern.orm.session.SessionStrategy;
import com.jpattern.orm.session.datasource.DataSourceConnection;
import com.jpattern.orm.session.datasource.DataSourceSessionStrategy;
import com.jpattern.orm.session.datasource.IConnectionCaller;
import javax.sql.DataSource;

public class DataSourceSessionProvider
extends SessionProvider {
    private final ThreadLocal<DataSourceConnection> threadLocalConnection = new ThreadLocal();
    private final DataSource dataSource;

    public DataSourceSessionProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public SessionStrategy getSessionStrategy() {
        return new DataSourceSessionStrategy(this);
    }

    final DataSourceConnection getConnection(boolean readOnly, IConnectionCaller connectionCaller) {
        DataSourceConnection conn;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("new connection asked by " + connectionCaller);
        }
        if ((conn = this.threadLocalConnection.get()) == null || !conn.isValid()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("no valid connections found, a new one will be created");
            }
            conn = new DataSourceConnection(this.dataSource, readOnly);
            this.threadLocalConnection.set(conn);
        }
        conn.setReadOnly(readOnly);
        conn.addCaller(connectionCaller);
        return conn;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }
}

