/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session;

import com.jpattern.orm.dialect.DBType;
import com.jpattern.orm.dialect.DetermineDBType;
import com.jpattern.orm.session.SessionStrategy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SessionProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DBType dbType;

    public abstract SessionStrategy getSessionStrategy();

    public abstract DataSource getDataSource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DBType getDBType() {
        if (this.dbType == null) {
            Connection connection = null;
            this.dbType = DBType.UNDEFINED;
            try {
                DataSource dataSource = this.getDataSource();
                if (dataSource != null) {
                    connection = dataSource.getConnection();
                    DatabaseMetaData metaData = connection.getMetaData();
                    String driverName = metaData.getDriverName();
                    String driverVersion = metaData.getDriverVersion();
                    String url = metaData.getURL();
                    String databaseProductName = metaData.getDatabaseProductName();
                    this.getLogger().info("DB username: " + metaData.getUserName());
                    this.getLogger().info("DB driver name: " + driverName);
                    this.getLogger().info("DB driver version: " + driverVersion);
                    this.getLogger().info("DB url: " + url);
                    this.getLogger().info("DB product name: " + databaseProductName);
                    this.getLogger().info("DB product version: " + metaData.getDatabaseProductVersion());
                    this.dbType = new DetermineDBType().determineDBType(driverName, url, databaseProductName);
                }
            }
            catch (SQLException ex) {
                this.getLogger().warn("Error while determining the database type");
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            this.getLogger().info("DB type is " + (Object)((Object)this.dbType));
        }
        return this.dbType;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

