/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.session.BatchPreparedStatementSetter;
import com.jpattern.orm.session.GeneratedKeyReader;
import com.jpattern.orm.session.PreparedStatementSetter;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.ResultSetRowReader;
import com.jpattern.orm.session.SqlPerformer;
import com.jpattern.orm.session.SqlPerformerStrategy;
import com.jpattern.orm.session.reader.ArrayResultSetReader;
import com.jpattern.orm.session.reader.BigDecimalResultSetReader;
import com.jpattern.orm.session.reader.BooleanResultSetReader;
import com.jpattern.orm.session.reader.DoubleResultSetReader;
import com.jpattern.orm.session.reader.FloatResultSetReader;
import com.jpattern.orm.session.reader.IntegerResultSetReader;
import com.jpattern.orm.session.reader.ListResultSetReader;
import com.jpattern.orm.session.reader.LongResultSetReader;
import com.jpattern.orm.session.reader.ResultSetRowReaderToResultSetReader;
import com.jpattern.orm.session.reader.ResultSetRowReaderToResultSetReaderUnique;
import com.jpattern.orm.session.reader.StringResultSetReader;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainSqlPerformer
implements SqlPerformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SqlPerformerStrategy sqlPerformerStrategy;
    private int queryTimeout = 0;
    private int maxRows = 0;

    public PlainSqlPerformer(SqlPerformerStrategy sqlPerformerStrategy) {
        this.sqlPerformerStrategy = sqlPerformerStrategy;
    }

    @Override
    public final void setMaxRows(int maxRows) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("max rows sets to " + maxRows);
        }
        this.maxRows = maxRows;
    }

    @Override
    public final int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public final void setQueryTimeout(int queryTimeout) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("queryTimeout sets to " + queryTimeout);
        }
        this.queryTimeout = queryTimeout;
    }

    @Override
    public final int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public final Integer queryForInt(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new IntegerResultSetReader(), values);
    }

    @Override
    public final Integer queryForInt(String sql, Collection<?> values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new IntegerResultSetReader(), values);
    }

    @Override
    public final Long queryForLong(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new LongResultSetReader(), values);
    }

    @Override
    public final Long queryForLong(String sql, Collection<?> values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new LongResultSetReader(), values);
    }

    @Override
    public final Double queryForDouble(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new DoubleResultSetReader(), values);
    }

    @Override
    public final Double queryForDouble(String sql, Collection<?> values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new DoubleResultSetReader(), values);
    }

    @Override
    public final Float queryForFloat(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new FloatResultSetReader(), values);
    }

    @Override
    public final Float queryForFloat(String sql, Collection<?> values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new FloatResultSetReader(), values);
    }

    @Override
    public final String queryForString(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new StringResultSetReader(), values);
    }

    @Override
    public final String queryForString(String sql, Collection<?> values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new StringResultSetReader(), values);
    }

    @Override
    public final Boolean queryForBoolean(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new BooleanResultSetReader(), values);
    }

    @Override
    public final Boolean queryForBoolean(String sql, Collection<?> values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new BooleanResultSetReader(), values);
    }

    @Override
    public final BigDecimal queryForBigDecimal(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new BigDecimalResultSetReader(), values);
    }

    @Override
    public final BigDecimal queryForBigDecimal(String sql, Collection<?> values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new BigDecimalResultSetReader(), values);
    }

    @Override
    public final Object[] queryForArray(String sql, Object ... values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new ArrayResultSetReader(), values);
    }

    @Override
    public final Object[] queryForArray(String sql, Collection<?> values) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new ArrayResultSetReader(), values);
    }

    @Override
    public final List<Object[]> queryForList(String sql, Object ... values) throws OrmException {
        return this.query(sql, new ListResultSetReader(), values);
    }

    @Override
    public final List<Object[]> queryForList(String sql, Collection<?> values) throws OrmException {
        return this.query(sql, new ListResultSetReader(), values);
    }

    @Override
    public void execute(String sql) throws OrmException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Execute query: [" + sql + "]");
        }
        this.sqlPerformerStrategy.execute(sql, this.getQueryTimeout());
    }

    @Override
    public <T> T query(String sql, ResultSetReader<T> rse, final Object ... args) throws OrmException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Execute query: [" + sql + "]");
            if (args != null) {
                this.logger.debug("Query params: " + Arrays.toString(args));
            }
        }
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            @Override
            public void set(PreparedStatement ps) throws SQLException {
                int index = 0;
                for (Object arg : args) {
                    ps.setObject(++index, arg);
                }
            }
        };
        return this.sqlPerformerStrategy.query(sql, this.getQueryTimeout(), this.getMaxRows(), pss, rse);
    }

    @Override
    public <T> T query(String sql, ResultSetReader<T> rse, final Collection<?> args) throws OrmException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Execute query: [" + sql + "]");
            if (args != null) {
                this.logger.debug("Query params: " + args);
            }
        }
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            @Override
            public void set(PreparedStatement ps) throws SQLException {
                int index = 0;
                for (Object arg : args) {
                    ps.setObject(++index, arg);
                }
            }
        };
        return this.sqlPerformerStrategy.query(sql, this.getQueryTimeout(), this.getMaxRows(), pss, rse);
    }

    @Override
    public <T> List<T> query(String sql, ResultSetRowReader<T> rsrr, Object ... args) throws OrmException {
        return (List)this.query(sql, new ResultSetRowReaderToResultSetReader<T>(rsrr), args);
    }

    @Override
    public <T> List<T> query(String sql, ResultSetRowReader<T> rsrr, Collection<?> args) throws OrmException {
        return (List)this.query(sql, new ResultSetRowReaderToResultSetReader<T>(rsrr), args);
    }

    @Override
    public <T> T queryForUnique(String sql, ResultSetRowReader<T> rsrr, Object ... args) throws OrmException, OrmNotUniqueResultException {
        return this.query(sql, new ResultSetRowReaderToResultSetReaderUnique<T>(rsrr), args);
    }

    @Override
    public <T> T queryForUnique(String sql, ResultSetRowReader<T> rsrr, Collection<?> args) throws OrmException {
        return this.query(sql, new ResultSetRowReaderToResultSetReaderUnique<T>(rsrr), args);
    }

    @Override
    public int update(String sql, final Object ... args) throws OrmException {
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            @Override
            public void set(PreparedStatement ps) throws SQLException {
                if (PlainSqlPerformer.this.logger.isDebugEnabled()) {
                    PlainSqlPerformer.this.logger.debug("Query params: " + Arrays.toString(args));
                }
                for (int i = 0; i < args.length; ++i) {
                    ps.setObject(i + 1, args[i]);
                }
            }
        };
        return this.update(sql, pss);
    }

    @Override
    public int update(String sql, final Collection<?> args) throws OrmException {
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            @Override
            public void set(PreparedStatement ps) throws SQLException {
                if (PlainSqlPerformer.this.logger.isDebugEnabled()) {
                    PlainSqlPerformer.this.logger.debug("Query params: " + args);
                }
                int index = 0;
                for (Object object : args) {
                    ps.setObject(++index, object);
                }
            }
        };
        return this.update(sql, pss);
    }

    @Override
    public int update(String sql, PreparedStatementSetter psc) throws OrmException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Execute query: [" + sql + "]");
        }
        return this.sqlPerformerStrategy.update(sql, this.getQueryTimeout(), psc);
    }

    @Override
    public int update(String sql, GeneratedKeyReader generatedKeyReader, final Object ... args) throws OrmException {
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            @Override
            public void set(PreparedStatement ps) throws SQLException {
                if (PlainSqlPerformer.this.logger.isDebugEnabled()) {
                    PlainSqlPerformer.this.logger.debug("Query params: " + Arrays.toString(args));
                }
                for (int i = 0; i < args.length; ++i) {
                    ps.setObject(i + 1, args[i]);
                }
            }
        };
        return this.update(sql, generatedKeyReader, pss);
    }

    @Override
    public int update(String sql, GeneratedKeyReader generatedKeyReader, final Collection<?> args) throws OrmException {
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            @Override
            public void set(PreparedStatement ps) throws SQLException {
                if (PlainSqlPerformer.this.logger.isDebugEnabled()) {
                    PlainSqlPerformer.this.logger.debug("Query params: " + args);
                }
                int index = 0;
                for (Object object : args) {
                    ps.setObject(++index, object);
                }
            }
        };
        return this.update(sql, generatedKeyReader, pss);
    }

    @Override
    public int update(String sql, GeneratedKeyReader generatedKeyReader, PreparedStatementSetter psc) throws OrmException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Execute query: [" + sql + "]");
        }
        return this.sqlPerformerStrategy.update(sql, this.getQueryTimeout(), generatedKeyReader, psc);
    }

    @Override
    public int[] batchUpdate(List<String> sqls) throws OrmException {
        return this.sqlPerformerStrategy.batchUpdate(sqls, this.getQueryTimeout());
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> args) throws OrmException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Execute query: [" + sql + "]");
        }
        return this.sqlPerformerStrategy.batchUpdate(sql, args, this.getQueryTimeout());
    }

    @Override
    public int[] batchUpdate(String sql, BatchPreparedStatementSetter psc) throws OrmException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Execute query: [" + sql + "]");
        }
        return this.sqlPerformerStrategy.batchUpdate(sql, psc, this.getQueryTimeout());
    }
}

