/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.session;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.exception.OrmNotUniqueResultManyResultsException;
import com.jpattern.orm.exception.OrmNotUniqueResultNoResultException;
import com.jpattern.orm.exception.OrmOptimisticLockException;
import com.jpattern.orm.mapper.IOrmClassTool;
import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.persistor.IOrmPersistor;
import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.persistor.type.ext.WrapperTypeArray;
import com.jpattern.orm.query.OrmClassToolMapNameSolver;
import com.jpattern.orm.query.delete.DeleteQuery;
import com.jpattern.orm.query.delete.DeleteQueryOrm;
import com.jpattern.orm.query.find.CustomFindQuery;
import com.jpattern.orm.query.find.CustomFindQueryOrm;
import com.jpattern.orm.query.find.FindQuery;
import com.jpattern.orm.query.find.FindQueryOrm;
import com.jpattern.orm.query.sql.PlainSqlExecutor;
import com.jpattern.orm.query.sql.SqlExecutor;
import com.jpattern.orm.query.update.UpdateQuery;
import com.jpattern.orm.query.update.UpdateQueryOrm;
import com.jpattern.orm.script.ScriptExecutor;
import com.jpattern.orm.script.ScriptExecutorImpl;
import com.jpattern.orm.session.GeneratedKeyReader;
import com.jpattern.orm.session.PlainSqlPerformer;
import com.jpattern.orm.session.PreparedStatementSetter;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SessionStrategy;
import com.jpattern.orm.session.SqlPerformer;
import com.jpattern.orm.session.TransactionCallback;
import com.jpattern.orm.transaction.OrmTransactionDefinition;
import com.jpattern.orm.transaction.Transaction;
import com.jpattern.orm.transaction.TransactionDefinition;
import com.jpattern.orm.validator.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrmSession
implements SessionSqlPerformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IOrmClassToolMap ormClassToolMap;
    private final SessionStrategy sessionStrategy;
    private final WrapperTypeArray wrapperTypeArray;
    private final Validator validator;
    private final TypeFactory typeFactory;

    public OrmSession(IOrmClassToolMap ormClassToolMap, SessionStrategy sessionStrategy, TypeFactory typeFactory, Validator validator) {
        this.ormClassToolMap = ormClassToolMap;
        this.sessionStrategy = sessionStrategy;
        this.typeFactory = typeFactory;
        this.validator = validator;
        this.wrapperTypeArray = new WrapperTypeArray(typeFactory);
    }

    @Override
    public final <T> FindQuery<T> findQuery(Class<T> clazz) throws OrmException {
        OrmClassToolMapNameSolver nameSolver = new OrmClassToolMapNameSolver(this.ormClassToolMap);
        FindQueryOrm<T> query = new FindQueryOrm<T>(this.ormClassToolMap, this, clazz, nameSolver.register(clazz), this.typeFactory);
        query.setNameSolver(nameSolver);
        return query;
    }

    @Override
    public final <T> FindQuery<T> findQuery(Class<T> clazz, String alias) throws OrmException {
        OrmClassToolMapNameSolver nameSolver = new OrmClassToolMapNameSolver(this.ormClassToolMap);
        FindQueryOrm<T> query = new FindQueryOrm<T>(this.ormClassToolMap, this, clazz, nameSolver.register(clazz, alias), this.typeFactory);
        query.setNameSolver(nameSolver);
        return query;
    }

    @Override
    public final CustomFindQuery findQuery(String selectClause, Class<?> clazz, String alias) throws OrmException {
        OrmClassToolMapNameSolver nameSolver = new OrmClassToolMapNameSolver(this.ormClassToolMap);
        CustomFindQueryOrm query = new CustomFindQueryOrm(selectClause, this.ormClassToolMap, this, clazz, nameSolver.register(clazz, alias), this.typeFactory);
        query.setNameSolver(nameSolver);
        return query;
    }

    public final IOrmClassToolMap getOrmClassToolMap() {
        return this.ormClassToolMap;
    }

    @Override
    public <T> boolean exist(T object) throws OrmException {
        IOrmClassTool<?> ormClassTool = this.getOrmClassToolMap().getOrmClassTool(object.getClass());
        return this.exist(object.getClass(), ormClassTool.getOrmPersistor().primaryKeyValues(object));
    }

    @Override
    public <T> boolean exist(Class<T> clazz, Object value) throws OrmException {
        return this.exist(clazz, new Object[]{value});
    }

    @Override
    public <T> boolean exist(Class<T> clazz, Object[] values) throws OrmException {
        IOrmClassTool<T> ormClassTool = this.getOrmClassToolMap().getOrmClassTool(clazz);
        SqlPerformer sqlExec = this.sqlPerformer();
        return sqlExec.queryForInt(ormClassTool.getOrmCRUDQuery().getExistQuery(), values) > 0;
    }

    @Override
    public final <T> T find(Class<T> clazz, Object value) throws OrmException {
        return this.find(clazz, new Object[]{value});
    }

    @Override
    public final <T> T find(Class<T> clazz, Object[] values) throws OrmException {
        final IOrmClassTool<T> ormClassTool = this.getOrmClassToolMap().getOrmClassTool(clazz);
        ResultSetReader resultSetReader = new ResultSetReader<T>(){

            @Override
            public T read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    Object result = ormClassTool.getOrmPersistor().mapRow("", resultSet, 0);
                    if (resultSet.next()) {
                        throw new OrmNotUniqueResultManyResultsException("The query execution returned more than one object. Zero or one expected.");
                    }
                    return result;
                }
                return null;
            }
        };
        SqlPerformer sqlExec = this.sqlPerformer();
        sqlExec.setMaxRows(1);
        return sqlExec.query(ormClassTool.getOrmCRUDQuery().getLoadQuery(), resultSetReader, this.wrapperTypeArray.unWrap(values));
    }

    @Override
    public final <T> T findUnique(Class<T> clazz, Object value) throws OrmException, OrmNotUniqueResultException {
        return this.findUnique(clazz, new Object[]{value});
    }

    @Override
    public final <T> T findUnique(Class<T> clazz, Object[] values) throws OrmException, OrmNotUniqueResultException {
        T result = this.find(clazz, values);
        if (result == null) {
            throw new OrmNotUniqueResultNoResultException("No objects found.");
        }
        return result;
    }

    @Override
    public final <T> T save(T object) throws OrmException {
        this.validator.validate(object);
        final IOrmClassTool<?> ormClassTool = this.getOrmClassToolMap().getOrmClassTool(object.getClass());
        final IOrmPersistor<?> persistor = ormClassTool.getOrmPersistor();
        SqlPerformer sqlExec = this.sqlPerformer();
        final Object resultObject = ormClassTool.getOrmPersistor().clone(object);
        persistor.increaseVersion(resultObject, true);
        if (!ormClassTool.getOrmPersistor().useKeyGenerators(resultObject)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Saving object without using generators");
            }
            String sql = ormClassTool.getOrmCRUDQuery().getSaveQueryWithoutGenerators();
            sqlExec.update(sql, new PreparedStatementSetter(){

                @Override
                public void set(PreparedStatement ps) throws SQLException {
                    persistor.setAllValues(resultObject, ps);
                }
            });
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Saving object using generators");
            }
            String sql = ormClassTool.getOrmCRUDQuery().getSaveQuery();
            GeneratedKeyReader generatedKeyExtractor = new GeneratedKeyReader(){

                @Override
                public void read(ResultSet generatedKeyResultSet) throws SQLException {
                    if (generatedKeyResultSet.next()) {
                        ormClassTool.getOrmPersistor().updateGeneratedValues(generatedKeyResultSet, resultObject);
                    }
                }

                @Override
                public String[] generatedColumnNames() {
                    return ormClassTool.getClassMap().getAllGeneratedColumnDBNames();
                }
            };
            sqlExec.update(sql, generatedKeyExtractor, new PreparedStatementSetter(){

                @Override
                public void set(PreparedStatement ps) throws SQLException {
                    persistor.setAllNotGeneratedValues(resultObject, ps);
                }
            });
        }
        return (T)resultObject;
    }

    @Override
    public final <T> T update(T object) throws OrmException {
        this.validator.validate(object);
        IOrmClassTool<?> ormClassTool = this.getOrmClassToolMap().getOrmClassTool(object.getClass());
        final IOrmPersistor<?> persistor = ormClassTool.getOrmPersistor();
        SqlPerformer sqlExec = this.sqlPerformer();
        final Object resultObject = persistor.clone(object);
        if (ormClassTool.getOrmPersistor().isVersionable()) {
            int rightVersion = sqlExec.queryForInt(ormClassTool.getOrmCRUDQuery().getBeanVersionQuery(), ormClassTool.getOrmPersistor().primaryKeyAndVersionValues(resultObject));
            if (rightVersion == 0) {
                throw new OrmOptimisticLockException("The bean of class [" + resultObject.getClass() + "] cannot be updated. Version in the DB is not the expected one.");
            }
            ormClassTool.getOrmPersistor().increaseVersion(resultObject, false);
        }
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            @Override
            public void set(PreparedStatement ps) throws SQLException {
                persistor.setNotPrimaryKeyAndThenPrimaryKeyValues(resultObject, ps);
            }
        };
        sqlExec.update(ormClassTool.getOrmCRUDQuery().getUpdateQuery(), pss);
        return (T)resultObject;
    }

    @Override
    public final UpdateQuery updateQuery(Class<?> clazz) throws OrmException {
        OrmClassToolMapNameSolver nameSolver = new OrmClassToolMapNameSolver(this.ormClassToolMap);
        nameSolver.alwaysResolveWithoutAlias(true);
        nameSolver.register(clazz);
        UpdateQueryOrm update = new UpdateQueryOrm(clazz, this.ormClassToolMap, this, this.typeFactory);
        update.setNameSolver(nameSolver);
        return update;
    }

    @Override
    public final UpdateQuery updateQuery(Class<?> clazz, String alias) throws OrmException {
        OrmClassToolMapNameSolver nameSolver = new OrmClassToolMapNameSolver(this.ormClassToolMap);
        nameSolver.alwaysResolveWithoutAlias(true);
        nameSolver.register(clazz, alias);
        UpdateQueryOrm update = new UpdateQueryOrm(clazz, this.ormClassToolMap, this, this.typeFactory);
        update.setNameSolver(nameSolver);
        return update;
    }

    @Override
    public final <T> int delete(T object) throws OrmException {
        IOrmClassTool<?> ormClassTool = this.getOrmClassToolMap().getOrmClassTool(object.getClass());
        SqlPerformer sqlExec = this.sqlPerformer();
        return sqlExec.update(ormClassTool.getOrmCRUDQuery().getDeleteQuery(), ormClassTool.getOrmPersistor().primaryKeyValues(object));
    }

    @Override
    public final <T> int delete(List<T> objects) throws OrmException {
        int result = 0;
        for (T object : objects) {
            result += this.delete(object);
        }
        return result;
    }

    @Override
    public final DeleteQuery deleteQuery(Class<?> clazz) throws OrmException {
        OrmClassToolMapNameSolver nameSolver = new OrmClassToolMapNameSolver(this.ormClassToolMap);
        nameSolver.register(clazz);
        nameSolver.alwaysResolveWithoutAlias(true);
        DeleteQueryOrm delete = new DeleteQueryOrm(clazz, this.ormClassToolMap, this, this.typeFactory);
        delete.setNameSolver(nameSolver);
        return delete;
    }

    @Override
    public final DeleteQuery deleteQuery(Class<?> clazz, String alias) throws OrmException {
        OrmClassToolMapNameSolver nameSolver = new OrmClassToolMapNameSolver(this.ormClassToolMap);
        nameSolver.register(clazz, alias);
        nameSolver.alwaysResolveWithoutAlias(true);
        DeleteQueryOrm delete = new DeleteQueryOrm(clazz, this.ormClassToolMap, this, this.typeFactory);
        delete.setNameSolver(nameSolver);
        return delete;
    }

    @Override
    public final ScriptExecutor scriptExecutor() throws OrmException {
        return new ScriptExecutorImpl(this);
    }

    @Override
    public final SqlExecutor sqlExecutor() {
        return new PlainSqlExecutor(this);
    }

    @Override
    public final Transaction transaction() throws OrmException {
        return this.transaction(new OrmTransactionDefinition());
    }

    @Override
    public Transaction transaction(TransactionDefinition transactionDefinition) throws OrmException {
        return this.sessionStrategy.getTransaction(transactionDefinition);
    }

    @Override
    public <T> T doInTransaction(TransactionCallback<T> transactionCallback) throws OrmException {
        return this.doInTransaction(new OrmTransactionDefinition(), transactionCallback);
    }

    @Override
    public <T> T doInTransaction(TransactionDefinition transactionDefinition, TransactionCallback<T> transactionCallback) throws OrmException {
        T result;
        Transaction tx = this.transaction(transactionDefinition);
        try {
            result = transactionCallback.doInTransaction(this);
            tx.commit();
        }
        catch (RuntimeException e) {
            tx.rollback();
            throw e;
        }
        return result;
    }

    @Override
    public SqlPerformer sqlPerformer() throws OrmException {
        return new PlainSqlPerformer(this.sessionStrategy.sqlPerformerStrategy());
    }

    @Override
    public <T> T saveOrUpdate(T object) throws OrmException {
        IOrmClassTool<?> ormClassTool = this.getOrmClassToolMap().getOrmClassTool(object.getClass());
        if (ormClassTool.getOrmPersistor().hasConditionalGenerator()) {
            if (ormClassTool.getOrmPersistor().useKeyGenerators(object)) {
                return this.save(object);
            }
            return this.update(object);
        }
        if (this.exist(object)) {
            return this.update(object);
        }
        return this.save(object);
    }

    @Override
    public <T> List<T> save(Collection<T> objects) throws OrmException {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            result.add(this.save(object));
        }
        return result;
    }

    @Override
    public <T> List<T> saveOrUpdate(Collection<T> objects) throws OrmException {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            result.add(this.saveOrUpdate(object));
        }
        return result;
    }

    @Override
    public <T> List<T> update(Collection<T> objects) throws OrmException {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            result.add(this.update(object));
        }
        return result;
    }
}

