/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.script;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.script.ScriptExecutor;
import com.jpattern.orm.script.SessionParserCallback;
import com.jpattern.orm.script.StreamParser;
import com.jpattern.orm.session.SessionSqlPerformer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecutorImpl
implements ScriptExecutor {
    private final SessionSqlPerformer session;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ScriptExecutorImpl(SessionSqlPerformer session) {
        this.session = session;
    }

    @Override
    public void execute(String script) throws OrmException {
        Charset charset = Charset.defaultCharset();
        ByteArrayInputStream is = new ByteArrayInputStream(script.getBytes(charset));
        try {
            this.execute(is, charset);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    @Override
    public void execute(InputStream scriptStream) throws IOException, OrmException {
        this.execute(scriptStream, Charset.defaultCharset());
    }

    @Override
    public void execute(InputStream scriptStream, Charset charset) throws IOException, OrmException {
        this.logger.info("Begin script execution");
        StreamParser parser = new StreamParser(scriptStream, true, charset);
        SessionParserCallback spc = new SessionParserCallback(this.session);
        parser.parse(spc);
        this.logger.info("End script execution");
    }
}

