/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.update;

import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.persistor.type.ext.WrapperTypeList;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.SmartRenderableSqlQuery;
import com.jpattern.orm.query.update.UpdateQuery;
import com.jpattern.orm.query.update.UpdateSet;
import com.jpattern.orm.query.update.UpdateSetImpl;
import com.jpattern.orm.query.update.UpdateWhere;
import com.jpattern.orm.query.update.UpdateWhereImpl;
import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;
import java.util.List;

public class UpdateQueryOrm
extends SmartRenderableSqlQuery
implements UpdateQuery,
NameSolverConsumer {
    private final UpdateSetImpl set = new UpdateSetImpl(this);
    private final UpdateWhereImpl where = new UpdateWhereImpl(this);
    private int queryTimeout = 0;
    private final Class<?> clazz;
    private final IOrmClassToolMap ormClassToolMap;
    private final SessionSqlPerformer session;
    private final TypeFactory typeFactory;

    public UpdateQueryOrm(Class<?> clazz, IOrmClassToolMap ormClassToolMap, SessionSqlPerformer session, TypeFactory typeFactory) {
        this.clazz = clazz;
        this.ormClassToolMap = ormClassToolMap;
        this.session = session;
        this.typeFactory = typeFactory;
    }

    @Override
    public UpdateWhere where() {
        return this.where;
    }

    @Override
    public int perform() {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.appendValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.update(this.renderSql(), values);
    }

    @Override
    public final void appendValues(List<Object> values) {
        this.set.appendElementValues(values);
        this.where.appendElementValues(values);
    }

    @Override
    public UpdateQuery setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setNameSolver(NameSolver nameSolver) {
        this.where.setNameSolver(nameSolver);
        this.set.setNameSolver(nameSolver);
    }

    @Override
    public int getStatusVersion() {
        return this.set.getElementStatusVersion() + this.where.getElementStatusVersion();
    }

    @Override
    public final void doRender(StringBuilder StringBuilder2) {
        StringBuilder2.append("UPDATE ");
        StringBuilder2.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getClassMap().getTableInfo().getTableNameWithSchema());
        StringBuilder2.append(" ");
        this.set.renderSqlElement(StringBuilder2);
        this.where.renderSqlElement(StringBuilder2);
    }

    @Override
    public UpdateSet set() {
        return this.set;
    }
}

