/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.find;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.exception.OrmNotUniqueResultManyResultsException;
import com.jpattern.orm.exception.OrmNotUniqueResultNoResultException;
import com.jpattern.orm.mapper.IOrmClassTool;
import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.persistor.type.ext.WrapperTypeList;
import com.jpattern.orm.query.LockMode;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.OrmRowMapper;
import com.jpattern.orm.query.SmartRenderableSqlQuery;
import com.jpattern.orm.query.find.FindFromImpl;
import com.jpattern.orm.query.find.FindOrderBy;
import com.jpattern.orm.query.find.FindOrderByImpl;
import com.jpattern.orm.query.find.FindQuery;
import com.jpattern.orm.query.find.FindWhere;
import com.jpattern.orm.query.find.FindWhereImpl;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;
import com.jpattern.orm.util.GenericWrapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class FindQueryOrm<BEAN>
extends SmartRenderableSqlQuery
implements FindQuery<BEAN>,
NameSolverConsumer {
    private NameSolver nameSolver = new NullNameSolver();
    private final IOrmClassToolMap ormClassToolMap;
    private final Class<BEAN> clazz;
    private boolean distinct;
    private final SessionSqlPerformer session;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private LockMode lockMode = LockMode.NO_LOCK;
    private final FindWhereImpl<BEAN> where = new FindWhereImpl(this);
    private final FindOrderByImpl<BEAN> orderBy = new FindOrderByImpl(this);
    private final FindFromImpl<BEAN> from;
    private final Integer nameSolverClassId;
    private final TypeFactory typeFactory;
    private int versionStatus = 0;

    public FindQueryOrm(IOrmClassToolMap ormClassToolMap, SessionSqlPerformer session, Class<BEAN> clazz, Integer nameSolverClassId, TypeFactory typeFactory) {
        this.ormClassToolMap = ormClassToolMap;
        this.session = session;
        this.clazz = clazz;
        this.nameSolverClassId = nameSolverClassId;
        this.typeFactory = typeFactory;
        this.from = new FindFromImpl(this, ormClassToolMap, clazz, nameSolverClassId);
    }

    @Override
    public final FindWhere<BEAN> where() throws OrmException {
        return this.where;
    }

    @Override
    public final FindOrderBy<BEAN> orderBy() throws OrmException {
        return this.orderBy;
    }

    @Override
    public final int getMaxRows() throws OrmException {
        return this.maxRows;
    }

    @Override
    public final FindQuery<BEAN> setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @Override
    public final int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public final FindQuery<BEAN> setMaxRows(int maxRows) throws OrmException {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public void setNameSolver(NameSolver nameSolver) {
        this.nameSolver = nameSolver;
        this.where.setNameSolver(nameSolver);
        this.orderBy.setNameSolver(nameSolver);
        this.from.setNameSolver(nameSolver);
    }

    @Override
    public void find(final OrmRowMapper<BEAN> srr) throws OrmException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        final IOrmClassTool<BEAN> ormClassTool = this.ormClassToolMap.getOrmClassTool(this.clazz);
        ResultSetReader<Object> resultSetReader = new ResultSetReader<Object>(){

            @Override
            public Object read(ResultSet resultSet) throws SQLException {
                int rowCount = 0;
                while (resultSet.next()) {
                    srr.read(ormClassTool.getOrmPersistor().mapRow("", resultSet, rowCount), rowCount);
                    ++rowCount;
                }
                return null;
            }
        };
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        sqlExec.query(this.renderSql(), resultSetReader, values);
    }

    @Override
    public BEAN findUnique() throws OrmNotUniqueResultException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        final IOrmClassTool<BEAN> ormClassTool = this.ormClassToolMap.getOrmClassTool(this.clazz);
        final GenericWrapper<Object> resultsCount = new GenericWrapper<Object>(null);
        final GenericWrapper<Object> wrapper = new GenericWrapper<Object>(null);
        ResultSetReader<Object> resultSetReader = new ResultSetReader<Object>(){

            @Override
            public Object read(ResultSet resultSet) throws SQLException {
                if (resultSet.next()) {
                    resultsCount.setValue(1);
                    wrapper.setValue(ormClassTool.getOrmPersistor().mapRow("", resultSet, 0));
                    if (resultSet.next()) {
                        resultsCount.setValue(2);
                    }
                } else {
                    resultsCount.setValue(0);
                }
                return null;
            }
        };
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(2);
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        sqlExec.query(this.renderSql(), resultSetReader, values);
        if ((Integer)resultsCount.getValue() != 1) {
            if ((Integer)resultsCount.getValue() == 0) {
                throw new OrmNotUniqueResultNoResultException("The query execution returned a number of rows different than one: no results found");
            }
            throw new OrmNotUniqueResultManyResultsException("The query execution returned a number of rows different than one: more than one result found");
        }
        return wrapper.getValue();
    }

    @Override
    public int findRowCount() {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForInt(this.getGeneratedRowCountSql(), values);
    }

    @Override
    public FindQuery<BEAN> setDistinct(boolean distinct) {
        this.distinct = distinct;
        ++this.versionStatus;
        return this;
    }

    @Override
    public boolean isDistinct() throws OrmException {
        return this.distinct;
    }

    @Override
    public final int getStatusVersion() {
        return this.versionStatus + this.from.getElementStatusVersion() + this.where.getElementStatusVersion() + this.orderBy.getElementStatusVersion();
    }

    @Override
    public String getGeneratedRowCountSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT COUNT(*) ");
        this.from.renderSqlElement(stringBuilder);
        this.where.renderSqlElement(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public final void doRender(StringBuilder stringBuilder) {
        this.renderSelect(stringBuilder);
        this.from.renderSqlElement(stringBuilder);
        this.where.renderSqlElement(stringBuilder);
        this.orderBy.renderSqlElement(stringBuilder);
        stringBuilder.append(this.lockMode.getMode());
    }

    private void renderSelect(StringBuilder stringBuilder) {
        String alias = this.nameSolver.alias(this.nameSolverClassId);
        stringBuilder.append("SELECT ");
        if (this.distinct) {
            stringBuilder.append("DISTINCT ");
        }
        stringBuilder.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getOrmCRUDQuery().getBaseSelectClause(alias + "."));
        stringBuilder.append(" ");
    }

    @Override
    public final void appendValues(List<Object> values) {
        this.where.appendElementValues(values);
    }

    @Override
    public FindQuery<BEAN> setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        ++this.versionStatus;
        return this;
    }

    @Override
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    public FindQuery<BEAN> join(Class<?> joinClass) {
        return (FindQuery)this.from.join(joinClass);
    }

    @Override
    public FindQuery<BEAN> join(Class<?> joinClass, String joinClassAlias) {
        return (FindQuery)this.from.join(joinClass, joinClassAlias);
    }

    @Override
    public FindQuery<BEAN> naturalJoin(Class<?> joinClass) {
        return (FindQuery)this.from.naturalJoin(joinClass);
    }

    @Override
    public FindQuery<BEAN> naturalJoin(Class<?> joinClass, String joinClassAlias) {
        return (FindQuery)this.from.naturalJoin(joinClass, joinClassAlias);
    }

    @Override
    public FindQuery<BEAN> innerJoin(Class<?> joinClass) {
        return (FindQuery)this.from.innerJoin(joinClass);
    }

    @Override
    public FindQuery<BEAN> innerJoin(Class<?> joinClass, String joinClassAlias) {
        return (FindQuery)this.from.innerJoin(joinClass, joinClassAlias);
    }

    @Override
    public FindQuery<BEAN> innerJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return (FindQuery)this.from.innerJoin(joinClass, onLeftProperty, onRigthProperty);
    }

    @Override
    public FindQuery<BEAN> innerJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        return (FindQuery)this.from.innerJoin(joinClass, joinClassAlias, onLeftProperty, onRigthProperty);
    }

    @Override
    public FindQuery<BEAN> leftOuterJoin(Class<?> joinClass) {
        return (FindQuery)this.from.leftOuterJoin(joinClass);
    }

    @Override
    public FindQuery<BEAN> leftOuterJoin(Class<?> joinClass, String joinClassAlias) {
        return (FindQuery)this.from.leftOuterJoin(joinClass, joinClassAlias);
    }

    @Override
    public FindQuery<BEAN> leftOuterJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return (FindQuery)this.from.leftOuterJoin(joinClass, onLeftProperty, onRigthProperty);
    }

    @Override
    public FindQuery<BEAN> leftOuterJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        return (FindQuery)this.from.leftOuterJoin(joinClass, joinClassAlias, onLeftProperty, onRigthProperty);
    }

    @Override
    public FindQuery<BEAN> rightOuterJoin(Class<?> joinClass) {
        return (FindQuery)this.from.rightOuterJoin(joinClass);
    }

    @Override
    public FindQuery<BEAN> rightOuterJoin(Class<?> joinClass, String joinClassAlias) {
        return (FindQuery)this.from.rightOuterJoin(joinClass, joinClassAlias);
    }

    @Override
    public FindQuery<BEAN> rightOuterJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return (FindQuery)this.from.rightOuterJoin(joinClass, onLeftProperty, onRigthProperty);
    }

    @Override
    public FindQuery<BEAN> rightOuterJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        return (FindQuery)this.from.rightOuterJoin(joinClass, joinClassAlias, onLeftProperty, onRigthProperty);
    }

    @Override
    public FindQuery<BEAN> fullOuterJoin(Class<?> joinClass) {
        return (FindQuery)this.from.fullOuterJoin(joinClass);
    }

    @Override
    public FindQuery<BEAN> fullOuterJoin(Class<?> joinClass, String joinClassAlias) {
        return (FindQuery)this.from.fullOuterJoin(joinClass, joinClassAlias);
    }

    @Override
    public FindQuery<BEAN> fullOuterJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return (FindQuery)this.from.fullOuterJoin(joinClass, onLeftProperty, onRigthProperty);
    }

    @Override
    public FindQuery<BEAN> fullOuterJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        return (FindQuery)this.from.fullOuterJoin(joinClass, joinClassAlias, onLeftProperty, onRigthProperty);
    }

    @Override
    public List<BEAN> findList() {
        return this.findList(this.getMaxRows());
    }

    private List<BEAN> findList(int maxRows) {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        final IOrmClassTool<BEAN> ormClassTool = this.ormClassToolMap.getOrmClassTool(this.clazz);
        ResultSetReader resultSetReader = new ResultSetReader<List<BEAN>>(){

            @Override
            public List<BEAN> read(ResultSet resultSet) throws SQLException {
                ArrayList resultList = new ArrayList();
                int rowCount = 0;
                while (resultSet.next()) {
                    resultList.add(ormClassTool.getOrmPersistor().mapRow("", resultSet, rowCount++));
                }
                return resultList;
            }
        };
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return (List)sqlExec.query(this.renderSql(), resultSetReader, values);
    }

    @Override
    public BEAN find() throws OrmException, OrmNotUniqueResultException {
        List<BEAN> results = this.findList(1);
        if (!results.isEmpty()) {
            return results.get(0);
        }
        return null;
    }
}

