/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.find;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmNotUniqueResultException;
import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.persistor.type.ext.WrapperTypeList;
import com.jpattern.orm.query.LockMode;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.SmartRenderableSqlQuery;
import com.jpattern.orm.query.find.CustomFindFromImpl;
import com.jpattern.orm.query.find.CustomFindOrderBy;
import com.jpattern.orm.query.find.CustomFindOrderByImpl;
import com.jpattern.orm.query.find.CustomFindQuery;
import com.jpattern.orm.query.find.CustomFindSelectImpl;
import com.jpattern.orm.query.find.CustomFindWhere;
import com.jpattern.orm.query.find.CustomFindWhereImpl;
import com.jpattern.orm.session.ResultSetReader;
import com.jpattern.orm.session.ResultSetRowReader;
import com.jpattern.orm.session.SessionSqlPerformer;
import com.jpattern.orm.session.SqlPerformer;
import java.math.BigDecimal;
import java.util.List;

public class CustomFindQueryOrm
extends SmartRenderableSqlQuery
implements CustomFindQuery,
NameSolverConsumer {
    private final CustomFindSelectImpl select;
    private final SessionSqlPerformer session;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private LockMode lockMode = LockMode.NO_LOCK;
    private final CustomFindWhereImpl where = new CustomFindWhereImpl(this);
    private final CustomFindOrderByImpl orderBy = new CustomFindOrderByImpl(this);
    private final CustomFindFromImpl from;
    private final TypeFactory typeFactory;
    private int versionStatus = 0;

    public CustomFindQueryOrm(String selectClause, IOrmClassToolMap ormClassToolMap, SessionSqlPerformer session, Class<?> clazz, Integer nameSolverClassId, TypeFactory typeFactory) {
        this.session = session;
        this.typeFactory = typeFactory;
        this.from = new CustomFindFromImpl(this, ormClassToolMap, clazz, nameSolverClassId);
        this.select = new CustomFindSelectImpl(selectClause);
    }

    @Override
    public void setNameSolver(NameSolver nameSolver) {
        this.where.setNameSolver(nameSolver);
        this.orderBy.setNameSolver(nameSolver);
        this.from.setNameSolver(nameSolver);
        this.select.setNameSolver(nameSolver);
    }

    @Override
    public List<Object[]> findList() {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForList(this.renderSql(), values);
    }

    @Override
    public Object[] findUnique() throws OrmNotUniqueResultException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForArray(this.renderSql(), values);
    }

    @Override
    public final int getStatusVersion() {
        return this.versionStatus + this.select.getElementStatusVersion() + this.from.getElementStatusVersion() + this.where.getElementStatusVersion() + this.orderBy.getElementStatusVersion();
    }

    @Override
    public final void doRender(StringBuilder stringBuilder) {
        this.select.renderSqlElement(stringBuilder);
        this.from.renderSqlElement(stringBuilder);
        this.where.renderSqlElement(stringBuilder);
        this.orderBy.renderSqlElement(stringBuilder);
        stringBuilder.append(this.lockMode.getMode());
    }

    @Override
    public <T> T find(ResultSetReader<T> rse) throws OrmException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.query(this.renderSql(), rse, values);
    }

    @Override
    public <T> List<T> find(ResultSetRowReader<T> rsrr) throws OrmException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.query(this.renderSql(), rsrr, values);
    }

    @Override
    public <T> T findUnique(ResultSetRowReader<T> rsrr) throws OrmException, OrmNotUniqueResultException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForUnique(this.renderSql(), rsrr, values);
    }

    @Override
    public int findInt() throws OrmException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForInt(this.renderSql(), values);
    }

    @Override
    public long findLong() throws OrmException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForLong(this.renderSql(), values);
    }

    @Override
    public double findDouble() throws OrmException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForDouble(this.renderSql(), values);
    }

    @Override
    public float findFloat() throws OrmException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForFloat(this.renderSql(), values).floatValue();
    }

    @Override
    public String findString() throws OrmException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForString(this.renderSql(), values);
    }

    @Override
    public boolean findBoolean() throws OrmException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForBoolean(this.renderSql(), values);
    }

    @Override
    public BigDecimal findBigDecimal() throws OrmException {
        WrapperTypeList values = new WrapperTypeList(this.typeFactory);
        this.where.appendElementValues(values);
        SqlPerformer sqlExec = this.session.sqlPerformer();
        sqlExec.setMaxRows(this.getMaxRows());
        sqlExec.setQueryTimeout(this.getQueryTimeout());
        return sqlExec.queryForBigDecimal(this.renderSql(), values);
    }

    @Override
    public final int getMaxRows() throws OrmException {
        return this.maxRows;
    }

    @Override
    public final CustomFindQuery setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    @Override
    public final int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public final CustomFindQuery setMaxRows(int maxRows) throws OrmException {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public CustomFindQuery setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        ++this.versionStatus;
        return this;
    }

    @Override
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    public final CustomFindWhere where() throws OrmException {
        return this.where;
    }

    @Override
    public final CustomFindOrderBy orderBy() throws OrmException {
        return this.orderBy;
    }

    @Override
    public final void appendValues(List<Object> values) {
        this.where.appendElementValues(values);
    }

    public final String renderSqlElement() {
        return this.from.renderSqlElement();
    }

    public final void renderSqlElement(StringBuilder stringBuilder) {
        this.from.renderSqlElement(stringBuilder);
    }

    public final boolean isElementStatusChanged() {
        return this.from.isElementStatusChanged();
    }

    @Override
    public CustomFindQuery join(Class<?> joinClass) {
        return (CustomFindQuery)this.from.join(joinClass);
    }

    @Override
    public CustomFindQuery join(Class<?> joinClass, String joinClassAlias) {
        return (CustomFindQuery)this.from.join(joinClass, joinClassAlias);
    }

    @Override
    public CustomFindQuery naturalJoin(Class<?> joinClass) {
        return (CustomFindQuery)this.from.naturalJoin(joinClass);
    }

    @Override
    public CustomFindQuery naturalJoin(Class<?> joinClass, String joinClassAlias) {
        return (CustomFindQuery)this.from.naturalJoin(joinClass, joinClassAlias);
    }

    @Override
    public CustomFindQuery innerJoin(Class<?> joinClass) {
        return (CustomFindQuery)this.from.innerJoin(joinClass);
    }

    @Override
    public CustomFindQuery innerJoin(Class<?> joinClass, String joinClassAlias) {
        return (CustomFindQuery)this.from.innerJoin(joinClass, joinClassAlias);
    }

    @Override
    public CustomFindQuery innerJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return (CustomFindQuery)this.from.innerJoin(joinClass, onLeftProperty, onRigthProperty);
    }

    @Override
    public CustomFindQuery innerJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        return (CustomFindQuery)this.from.innerJoin(joinClass, joinClassAlias, onLeftProperty, onRigthProperty);
    }

    @Override
    public CustomFindQuery leftOuterJoin(Class<?> joinClass) {
        return (CustomFindQuery)this.from.leftOuterJoin(joinClass);
    }

    @Override
    public CustomFindQuery leftOuterJoin(Class<?> joinClass, String joinClassAlias) {
        return (CustomFindQuery)this.from.leftOuterJoin(joinClass, joinClassAlias);
    }

    @Override
    public CustomFindQuery leftOuterJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return (CustomFindQuery)this.from.leftOuterJoin(joinClass, onLeftProperty, onRigthProperty);
    }

    @Override
    public CustomFindQuery leftOuterJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        return (CustomFindQuery)this.from.leftOuterJoin(joinClass, joinClassAlias, onLeftProperty, onRigthProperty);
    }

    @Override
    public CustomFindQuery rightOuterJoin(Class<?> joinClass) {
        return (CustomFindQuery)this.from.rightOuterJoin(joinClass);
    }

    @Override
    public CustomFindQuery rightOuterJoin(Class<?> joinClass, String joinClassAlias) {
        return (CustomFindQuery)this.from.rightOuterJoin(joinClass, joinClassAlias);
    }

    @Override
    public CustomFindQuery rightOuterJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return (CustomFindQuery)this.from.rightOuterJoin(joinClass, onLeftProperty, onRigthProperty);
    }

    @Override
    public CustomFindQuery rightOuterJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        return (CustomFindQuery)this.from.rightOuterJoin(joinClass, joinClassAlias, onLeftProperty, onRigthProperty);
    }

    @Override
    public CustomFindQuery fullOuterJoin(Class<?> joinClass) {
        return (CustomFindQuery)this.from.fullOuterJoin(joinClass);
    }

    @Override
    public CustomFindQuery fullOuterJoin(Class<?> joinClass, String joinClassAlias) {
        return (CustomFindQuery)this.from.fullOuterJoin(joinClass, joinClassAlias);
    }

    @Override
    public CustomFindQuery fullOuterJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return (CustomFindQuery)this.from.fullOuterJoin(joinClass, onLeftProperty, onRigthProperty);
    }

    @Override
    public CustomFindQuery fullOuterJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        return (CustomFindQuery)this.from.fullOuterJoin(joinClass, joinClassAlias, onLeftProperty, onRigthProperty);
    }

    public final int getElementStatusVersion() {
        return this.from.getElementStatusVersion();
    }

    public final void doElementRender(StringBuilder stringBuilder) {
        this.from.doElementRender(stringBuilder);
    }

    public final void appendElementValues(List<Object> values) {
        this.from.appendElementValues(values);
    }

    public String toString() {
        return this.from.toString();
    }

    @Override
    public CustomFindQuery setDistinct(boolean distinct) {
        this.select.setDistinct(distinct);
        return this;
    }

    @Override
    public boolean isDistinct() throws OrmException {
        return this.select.isDistinct();
    }
}

