/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.clause.where;

import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.where.ExpressionElement;
import java.util.List;

public abstract class MultipleExpressionElement
extends SmartRenderableSqlSubElement
implements ExpressionElement {
    private final String relationType;
    private final List<ExpressionElement> expressionElements;

    public MultipleExpressionElement(String relationType, List<ExpressionElement> expressionElements) {
        this.expressionElements = expressionElements;
        this.relationType = relationType;
    }

    @Override
    public final int getElementStatusVersion() {
        return 0;
    }

    @Override
    public final void doElementRender(StringBuilder stringBuilder) {
        stringBuilder.append("( ");
        int last = this.expressionElements.size() - 1;
        if (last < 0) {
            stringBuilder.append("1=1 ");
        } else {
            for (int i = 0; i < this.expressionElements.size(); ++i) {
                this.expressionElements.get(i).renderSqlElement(stringBuilder);
                if (i == last) continue;
                stringBuilder.append(this.relationType);
            }
        }
        stringBuilder.append(") ");
    }

    @Override
    public void setNameSolver(NameSolver nameSolver) {
        for (ExpressionElement expressionElement : this.expressionElements) {
            expressionElement.setNameSolver(nameSolver);
        }
    }

    @Override
    public final void appendElementValues(List<Object> values) {
        for (ExpressionElement expressionElement : this.expressionElements) {
            expressionElement.appendElementValues(values);
        }
    }
}

