/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.clause.where;

import com.jpattern.orm.exception.OrmQueryFormatException;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.where.ExpressionElement;
import com.jpattern.orm.query.clause.where.NullPropertyDecorator;
import com.jpattern.orm.query.clause.where.PropertyDecorator;
import java.util.Collection;
import java.util.List;

public abstract class AExpressionElement
extends SmartRenderableSqlSubElement
implements ExpressionElement {
    private String property;
    private boolean singleValue;
    private Object value;
    private boolean multipleValues;
    private Collection<?> values;
    private NameSolver nameSolver = new NullNameSolver();
    private PropertyDecorator propertyDecorator = new NullPropertyDecorator();
    private PropertyDecorator valueDecorator = new NullPropertyDecorator();

    @Override
    public void setNameSolver(NameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    public final boolean hasValue() {
        return this.singleValue;
    }

    public final boolean hasValues() {
        return this.multipleValues && this.values != null && this.values.size() > 0;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.singleValue = true;
        this.multipleValues = false;
        this.value = value;
    }

    public Collection<?> getValues() {
        return this.values;
    }

    public void setValues(Collection<?> values) {
        this.singleValue = false;
        this.multipleValues = true;
        this.values = values;
    }

    public final String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    protected NameSolver nameSolver() {
        return this.nameSolver;
    }

    protected PropertyDecorator getPropertyDecorator() {
        return this.propertyDecorator;
    }

    protected void setPropertyDecorator(PropertyDecorator propertyDecorator) {
        this.propertyDecorator = propertyDecorator;
    }

    protected PropertyDecorator getValueDecorator() {
        return this.valueDecorator;
    }

    protected void setValueDecorator(PropertyDecorator valueDecorator) {
        this.valueDecorator = valueDecorator;
    }

    @Override
    public final void doElementRender(StringBuilder query) throws OrmQueryFormatException {
        query.append(this.getPropertyDecorator().decore(this.nameSolver().solvePropertyName(this.getProperty())));
        query.append(" ");
        query.append(this.getExpressionElementKey());
        query.append(" ");
        this.appendQuestionMarks(query);
    }

    private void appendQuestionMarks(StringBuilder query) {
        if (this.hasValue()) {
            query.append(this.getValueDecorator().decore("?") + " ");
            return;
        }
        if (this.hasValues()) {
            query.append("( ");
            for (int i = 0; i < this.getValues().size() - 1; ++i) {
                query.append(this.getValueDecorator().decore("?") + ", ");
            }
            query.append(this.getValueDecorator().decore("?") + " ) ");
        }
    }

    @Override
    public final int getElementStatusVersion() {
        return 0;
    }

    public abstract String getExpressionElementKey();

    @Override
    public final void appendElementValues(List<Object> values) {
        if (this.hasValue()) {
            values.add(this.value);
        }
        if (this.hasValues()) {
            values.addAll(this.values);
        }
    }
}

