/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.clause.from;

import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.from.FromElement;
import java.util.List;

public abstract class AFromElement
extends SmartRenderableSqlSubElement
implements FromElement {
    protected final Class<?> joinClass;
    private NameSolver nameSolver;
    protected final IOrmClassToolMap ormClassToolMap;
    private final Integer nameSolverClassId;

    public AFromElement(IOrmClassToolMap ormClassToolMap, Class<?> joinClass, Integer nameSolverClassId) {
        this.ormClassToolMap = ormClassToolMap;
        this.joinClass = joinClass;
        this.nameSolverClassId = nameSolverClassId;
    }

    @Override
    public void setNameSolver(NameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    @Override
    public final int getElementStatusVersion() {
        return 0;
    }

    @Override
    public final void doElementRender(StringBuilder stringBuilder) {
        String alias = this.nameSolver.alias(this.getNameSolverClassId());
        stringBuilder.append(this.getJoinName());
        stringBuilder.append(this.ormClassToolMap.getOrmClassTool(this.joinClass).getClassMap().getTableInfo().getTableNameWithSchema());
        stringBuilder.append(" ");
        stringBuilder.append(alias);
        if (this.hasOnClause()) {
            stringBuilder.append(" ON ");
            stringBuilder.append(this.nameSolver.solvePropertyName(this.onLeftProperty()));
            stringBuilder.append(" = ");
            stringBuilder.append(this.nameSolver.solvePropertyName(this.onRightProperty()));
        }
        stringBuilder.append(" ");
    }

    protected abstract String getJoinName();

    protected abstract boolean hasOnClause();

    protected abstract String onLeftProperty();

    protected abstract String onRightProperty();

    public Integer getNameSolverClassId() {
        return this.nameSolverClassId;
    }

    @Override
    public final void appendElementValues(List<Object> values) {
    }
}

