/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.clause;

import com.jpattern.orm.query.BaseFindQuery;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.Where;
import com.jpattern.orm.query.clause.where.Expression;
import com.jpattern.orm.query.clause.where.ExpressionElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class OrmWhere<T extends Where<?>>
extends SmartRenderableSqlSubElement
implements Where<T>,
NameSolverConsumer {
    List<ExpressionElement> elementList = new ArrayList<ExpressionElement>();
    private NameSolver nameSolver = new NullNameSolver();

    protected abstract T where();

    @Override
    public T allEq(Map<String, Object> propertyMap) {
        for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
            this.eq(entry.getKey(), entry.getValue());
        }
        return this.where();
    }

    @Override
    public T eq(String property, Object value) {
        return this.addExpression(Expression.eq(property, value));
    }

    @Override
    public T eqProperties(String firstProperty, String secondProperty) {
        return this.addExpression(Expression.eqProperties(firstProperty, secondProperty));
    }

    @Override
    public T le(String property, Object value) {
        return this.addExpression(Expression.le(property, value));
    }

    @Override
    public T leProperties(String firstProperty, String secondProperty) {
        return this.addExpression(Expression.leProperties(firstProperty, secondProperty));
    }

    @Override
    public T ge(String property, Object value) {
        return this.addExpression(Expression.ge(property, value));
    }

    @Override
    public T geProperties(String firstProperty, String secondProperty) {
        return this.addExpression(Expression.geProperties(firstProperty, secondProperty));
    }

    @Override
    public T lt(String property, Object value) {
        return this.addExpression(Expression.lt(property, value));
    }

    @Override
    public T ltProperties(String firstProperty, String secondProperty) {
        return this.addExpression(Expression.ltProperties(firstProperty, secondProperty));
    }

    @Override
    public T gt(String property, Object value) {
        return this.addExpression(Expression.gt(property, value));
    }

    @Override
    public T gtProperties(String firstProperty, String secondProperty) {
        return this.addExpression(Expression.gtProperties(firstProperty, secondProperty));
    }

    @Override
    public T ieq(String property, String value) {
        return this.addExpression(Expression.ieq(property, value));
    }

    @Override
    public T ieqProperties(String firstProperty, String secondProperty) {
        return this.addExpression(Expression.ieqProperties(firstProperty, secondProperty));
    }

    @Override
    public T ilike(String property, String value) {
        return this.addExpression(Expression.ilike(property, value));
    }

    @Override
    public T in(String property, Collection<?> values) {
        return this.addExpression(Expression.in(property, values));
    }

    @Override
    public T in(String property, Object[] values) {
        return this.in(property, Arrays.asList(values));
    }

    @Override
    public T in(String property, BaseFindQuery subQuery) {
        return this.addExpression(Expression.in(property, subQuery));
    }

    @Override
    public T nin(String property, Collection<?> values) {
        return this.addExpression(Expression.nin(property, values));
    }

    @Override
    public T nin(String property, Object[] values) {
        return this.nin(property, Arrays.asList(values));
    }

    @Override
    public T nin(String property, BaseFindQuery subQuery) {
        return this.addExpression(Expression.nin(property, subQuery));
    }

    @Override
    public T isNotNull(String property) {
        return this.addExpression(Expression.isNotNull(property));
    }

    @Override
    public T isNull(String property) {
        return this.addExpression(Expression.isNull(property));
    }

    @Override
    public T like(String property, String value) {
        return this.addExpression(Expression.like(property, value));
    }

    @Override
    public T nlike(String property, String value) {
        return this.addExpression(Expression.nlike(property, value));
    }

    @Override
    public T ne(String property, Object value) {
        return this.addExpression(Expression.ne(property, value));
    }

    @Override
    public T neProperties(String firstProperty, String secondProperty) {
        return this.addExpression(Expression.neProperties(firstProperty, secondProperty));
    }

    @Override
    public T not(ExpressionElement expression) {
        return this.addExpression(Expression.not(expression));
    }

    @Override
    public T or(ExpressionElement ... expressionElements) {
        return this.or(Arrays.asList(expressionElements));
    }

    @Override
    public T or(List<ExpressionElement> expressionElements) {
        return this.addExpression(Expression.or(expressionElements));
    }

    @Override
    public T and(ExpressionElement ... expressionElements) {
        return this.and(Arrays.asList(expressionElements));
    }

    @Override
    public T and(List<ExpressionElement> expressionElements) {
        return this.addExpression(Expression.and(expressionElements));
    }

    @Override
    public void setNameSolver(NameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    @Override
    public final void doElementRender(StringBuilder StringBuilder2) {
        boolean first = true;
        if (!this.elementList.isEmpty()) {
            StringBuilder2.append("WHERE ");
            for (ExpressionElement expressionElement : this.elementList) {
                if (!first) {
                    StringBuilder2.append("AND ");
                }
                expressionElement.renderSqlElement(StringBuilder2);
                first = false;
            }
        }
    }

    @Override
    public final void appendElementValues(List<Object> values) {
        for (ExpressionElement expressionElement : this.elementList) {
            expressionElement.appendElementValues(values);
        }
    }

    @Override
    public final int getElementStatusVersion() {
        return this.elementList.size();
    }

    private T addExpression(ExpressionElement expressionElement) {
        expressionElement.setNameSolver(this.nameSolver);
        this.elementList.add(expressionElement);
        return this.where();
    }
}

