/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.clause;

import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.OrderBy;
import com.jpattern.orm.query.clause.order.OrderByType;
import com.jpattern.orm.query.clause.order.OrderElement;
import com.jpattern.orm.query.clause.order.OrmOrderElement;
import java.util.ArrayList;
import java.util.List;

public abstract class OrmOrderBy<T extends OrderBy<?>>
extends SmartRenderableSqlSubElement
implements OrderBy<T>,
NameSolverConsumer {
    private NameSolver nameSolver = new NullNameSolver();
    private final List<OrderElement> elementList = new ArrayList<OrderElement>();

    protected abstract T orderBy();

    @Override
    public final void doElementRender(StringBuilder stringBuilder) {
        if (!this.elementList.isEmpty()) {
            stringBuilder.append("ORDER BY ");
            for (OrderElement expressionElement : this.elementList) {
                expressionElement.renderSqlElement(stringBuilder);
            }
        }
    }

    @Override
    public final int getElementStatusVersion() {
        return this.elementList.size();
    }

    @Override
    public void setNameSolver(NameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    @Override
    public final void appendElementValues(List<Object> values) {
    }

    @Override
    public T asc(String property) {
        return this.addOrderElement(property, OrderByType.ASC);
    }

    @Override
    public T desc(String property) {
        return this.addOrderElement(property, OrderByType.DESC);
    }

    @Override
    public T ascNullsFirst(String property) {
        return this.addOrderElement(property, OrderByType.ASC_NULLS_FIRST);
    }

    @Override
    public T ascNullsLast(String property) {
        return this.addOrderElement(property, OrderByType.ASC_NULLS_LAST);
    }

    @Override
    public T descNullsFirst(String property) {
        return this.addOrderElement(property, OrderByType.DESC_NULLS_FIRST);
    }

    @Override
    public T descNullsLast(String property) {
        return this.addOrderElement(property, OrderByType.DESC_NULLS_LAST);
    }

    private T addOrderElement(String property, OrderByType orderByType) {
        this.elementList.add(new OrmOrderElement(this.nameSolver, property, this.elementList.isEmpty(), orderByType));
        return this.orderBy();
    }
}

