/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.clause;

import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.From;
import com.jpattern.orm.query.clause.from.FromElement;
import com.jpattern.orm.query.clause.from.FullOuterJoinElement;
import com.jpattern.orm.query.clause.from.InnerJoinElement;
import com.jpattern.orm.query.clause.from.JoinElement;
import com.jpattern.orm.query.clause.from.LeftOuterJoinElement;
import com.jpattern.orm.query.clause.from.NaturalJoinElement;
import com.jpattern.orm.query.clause.from.RightOuterJoinElement;
import java.util.ArrayList;
import java.util.List;

public abstract class OrmFrom<T extends From<?>>
extends SmartRenderableSqlSubElement
implements From<T>,
NameSolverConsumer {
    private NameSolver nameSolver = new NullNameSolver();
    private final List<FromElement> joinElements = new ArrayList<FromElement>();
    private final IOrmClassToolMap ormClassToolMap;
    private final Class<?> clazz;
    private final Integer nameSolverClassId;

    public OrmFrom(IOrmClassToolMap ormClassToolMap, Class<?> clazz, Integer nameSolverClassId) {
        this.ormClassToolMap = ormClassToolMap;
        this.clazz = clazz;
        this.nameSolverClassId = nameSolverClassId;
    }

    protected abstract T from();

    @Override
    public T join(Class<?> joinClass) {
        return this.join(joinClass, joinClass.getSimpleName());
    }

    @Override
    public T join(Class<?> joinClass, String joinClassAlias) {
        Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
        return this.addJoinElement(new JoinElement(this.ormClassToolMap, joinClass, nameSolverClassId));
    }

    @Override
    public T naturalJoin(Class<?> joinClass) {
        return this.naturalJoin(joinClass, joinClass.getSimpleName());
    }

    @Override
    public T naturalJoin(Class<?> joinClass, String joinClassAlias) {
        Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
        return this.addJoinElement(new NaturalJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId));
    }

    @Override
    public T innerJoin(Class<?> joinClass) {
        return this.innerJoin(joinClass, joinClass.getSimpleName());
    }

    @Override
    public T innerJoin(Class<?> joinClass, String joinClassAlias) {
        Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
        return this.addJoinElement(new InnerJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId));
    }

    @Override
    public T innerJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return this.innerJoin(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
    }

    @Override
    public T innerJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
        return this.addJoinElement(new InnerJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId, onLeftProperty, onRigthProperty));
    }

    @Override
    public T leftOuterJoin(Class<?> joinClass) {
        return this.leftOuterJoin(joinClass, joinClass.getSimpleName());
    }

    @Override
    public T leftOuterJoin(Class<?> joinClass, String joinClassAlias) {
        Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
        return this.addJoinElement(new LeftOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId));
    }

    @Override
    public T leftOuterJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return this.leftOuterJoin(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
    }

    @Override
    public T leftOuterJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
        return this.addJoinElement(new LeftOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId, onLeftProperty, onRigthProperty));
    }

    @Override
    public T rightOuterJoin(Class<?> joinClass) {
        return this.rightOuterJoin(joinClass, joinClass.getSimpleName());
    }

    @Override
    public T rightOuterJoin(Class<?> joinClass, String joinClassAlias) {
        Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
        return this.addJoinElement(new RightOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId));
    }

    @Override
    public T rightOuterJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return this.rightOuterJoin(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
    }

    @Override
    public T rightOuterJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
        return this.addJoinElement(new RightOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId, onLeftProperty, onRigthProperty));
    }

    @Override
    public T fullOuterJoin(Class<?> joinClass) {
        return this.fullOuterJoin(joinClass, joinClass.getSimpleName());
    }

    @Override
    public T fullOuterJoin(Class<?> joinClass, String joinClassAlias) {
        Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
        return this.addJoinElement(new FullOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId));
    }

    @Override
    public T fullOuterJoin(Class<?> joinClass, String onLeftProperty, String onRigthProperty) {
        return this.fullOuterJoin(joinClass, joinClass.getSimpleName(), onLeftProperty, onRigthProperty);
    }

    @Override
    public T fullOuterJoin(Class<?> joinClass, String joinClassAlias, String onLeftProperty, String onRigthProperty) {
        Integer nameSolverClassId = this.nameSolver.register(joinClass, joinClassAlias);
        return this.addJoinElement(new FullOuterJoinElement(this.ormClassToolMap, joinClass, nameSolverClassId, onLeftProperty, onRigthProperty));
    }

    @Override
    public void setNameSolver(NameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    @Override
    public final int getElementStatusVersion() {
        return this.joinElements.size();
    }

    @Override
    public final void doElementRender(StringBuilder stringBuilder) {
        String alias = this.nameSolver.alias(this.nameSolverClassId);
        stringBuilder.append("FROM ");
        stringBuilder.append(this.ormClassToolMap.getOrmClassTool(this.clazz).getClassMap().getTableInfo().getTableNameWithSchema());
        stringBuilder.append(" ");
        stringBuilder.append(alias);
        stringBuilder.append(" ");
        for (FromElement joinElement : this.joinElements) {
            joinElement.renderSqlElement(stringBuilder);
        }
    }

    @Override
    public final void appendElementValues(List<Object> values) {
    }

    private T addJoinElement(FromElement joinElement) {
        joinElement.setNameSolver(this.nameSolver);
        this.joinElements.add(joinElement);
        return this.from();
    }
}

