/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query.clause;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.query.NameSolver;
import com.jpattern.orm.query.NameSolverConsumer;
import com.jpattern.orm.query.NullNameSolver;
import com.jpattern.orm.query.SmartRenderableSqlSubElement;
import com.jpattern.orm.query.clause.Select;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class OrmCustomSelect<T extends Select<?>>
extends SmartRenderableSqlSubElement
implements Select<T>,
NameSolverConsumer {
    private static Pattern patternProperty = Pattern.compile("[a-zA-Z_0-9]+[\\.][a-zA-Z_0-9]+[\\.][a-zA-Z_0-9]+|[a-zA-Z_0-9]+[\\.][a-zA-Z_0-9]+");
    private final String selectClause;
    private NameSolver nameSolver = new NullNameSolver();
    private int versionStatus = 0;
    private boolean distinct = false;

    public OrmCustomSelect(String selectClause) {
        this.selectClause = selectClause;
    }

    @Override
    public final void doElementRender(StringBuilder stringBuilder) {
        stringBuilder.append("SELECT ");
        if (this.distinct) {
            stringBuilder.append("DISTINCT ");
        }
        this.solveProperties(stringBuilder, this.selectClause);
        stringBuilder.append(" ");
    }

    @Override
    public final int getElementStatusVersion() {
        return this.versionStatus;
    }

    @Override
    public final void appendElementValues(List<Object> values) {
    }

    @Override
    public void setNameSolver(NameSolver nameSolver) {
        this.nameSolver = nameSolver;
    }

    private void solveProperties(StringBuilder stringBuilder, String token) {
        Matcher m = patternProperty.matcher(token);
        int beginIndex = 0;
        while (m.find()) {
            stringBuilder.append(token.substring(beginIndex, m.start()));
            stringBuilder.append(this.nameSolver.solvePropertyName(m.group(), m.group()));
            beginIndex = m.end();
        }
        stringBuilder.append(token.substring(beginIndex, token.length()));
    }

    public T setDistinct(boolean distinct) {
        this.distinct = distinct;
        ++this.versionStatus;
        return this.select();
    }

    public boolean isDistinct() throws OrmException {
        return this.distinct;
    }

    protected abstract T select();
}

