/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.query;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.exception.OrmQueryFormatException;
import com.jpattern.orm.mapper.IOrmClassTool;
import com.jpattern.orm.mapper.IOrmClassToolMap;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.query.NameSolver;
import java.util.LinkedHashMap;
import java.util.Map;

public class OrmClassToolMapNameSolver
implements NameSolver {
    private final Map<String, IClassMap<?>> registeredClass = new LinkedHashMap();
    private final Map<Integer, String> classAlias = new LinkedHashMap<Integer, String>();
    private final IOrmClassToolMap ormClassToolMap;
    private boolean resolveWithoutAlias = false;
    private String defaultAlias = null;
    private int registeredClassCount = 0;

    public OrmClassToolMapNameSolver(IOrmClassToolMap ormClassToolMap) {
        this.ormClassToolMap = ormClassToolMap;
    }

    @Override
    public String solvePropertyName(String property) throws OrmException {
        if (this.resolveWithoutAlias) {
            return this.solvePropertyNameWithoutAlias(property);
        }
        String alias = this.alias(property);
        String field = this.field(property);
        if (!this.registeredClass.containsKey(alias)) {
            throw new OrmException("Alias [" + alias + "] is not associated with an Orm Entity. Registered alias are: " + this.registeredClass.keySet());
        }
        String dbColumn = this.getDbColumn(alias, field);
        return alias + "." + dbColumn;
    }

    @Override
    public String solvePropertyName(String property, String defaultValue) throws OrmException {
        String alias = this.alias(property);
        String field = this.field(property);
        if (!this.registeredClass.containsKey(alias)) {
            return defaultValue;
        }
        String dbColumn = this.getDbColumn(alias, field);
        return alias + "." + dbColumn;
    }

    @Override
    public <P> Integer register(Class<P> clazz) throws OrmException {
        return this.register(clazz, clazz.getSimpleName());
    }

    @Override
    public <P> Integer register(Class<P> clazz, String alias) throws OrmException {
        return this.register(clazz, alias, this.ormClassToolMap.getOrmClassTool(clazz));
    }

    private <P> Integer register(Class<P> clazz, String alias, IOrmClassTool<P> ormClassTool) throws OrmException {
        Integer classId = this.registeredClassCount++;
        this.registeredClass.put(alias, ormClassTool.getClassMap());
        this.classAlias.put(classId, alias);
        if (this.defaultAlias == null) {
            this.defaultAlias = alias;
        }
        return classId;
    }

    @Override
    public String alias(Integer classId) throws OrmException {
        if (!this.classAlias.containsKey(classId)) {
            throw new OrmException("No class are registered in this query with the id " + classId);
        }
        return this.classAlias.get(classId);
    }

    private String alias(String property) throws OrmException {
        try {
            return property.substring(0, property.lastIndexOf("."));
        }
        catch (Exception e) {
            return this.defaultAlias;
        }
    }

    private String field(String property) throws OrmException {
        try {
            return property.substring(property.lastIndexOf(".") + 1);
        }
        catch (Exception e) {
            throw new OrmException("Error parsing property [" + property + "], the format must be CLASS_NAME.CLASS_FIELD or CLASS_ALIAS.CLASS_FIELD");
        }
    }

    @Override
    public String solvePropertyNameWithoutAlias(String property) throws OrmException {
        String alias = this.alias(property);
        String field = this.field(property);
        if (!this.registeredClass.containsKey(alias)) {
            throw new OrmException("Alias [" + alias + "] is not associated with an Orm Entity. Registered alias are: " + this.registeredClass.keySet());
        }
        return this.getDbColumn(alias, field);
    }

    @Override
    public void alwaysResolveWithoutAlias(boolean resolveWithoutAlias) {
        this.resolveWithoutAlias = resolveWithoutAlias;
    }

    @Override
    public boolean getAlwaysResolveWithoutAlias() {
        return this.resolveWithoutAlias;
    }

    private String getDbColumn(String alias, String field) {
        String dbColumn = this.registeredClass.get(alias).getClassFieldByJavaName(field).getColumnInfo().getDBColumnName();
        if (dbColumn.isEmpty()) {
            throw new OrmQueryFormatException("Field with name [" + field + "] is not present or ignored for alias [" + alias + "]");
        }
        return dbColumn;
    }
}

