/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.persistor.version;

import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.persistor.version.BigDecimalVersionMath;
import com.jpattern.orm.persistor.version.IntegerVersionMath;
import com.jpattern.orm.persistor.version.LongVersionMath;
import com.jpattern.orm.persistor.version.NullVersionMath;
import com.jpattern.orm.persistor.version.VersionMath;
import com.jpattern.orm.util.MapUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class VersionMathFactory {
    private Map<Class<?>, VersionMath<?>> maths = new HashMap();

    public VersionMathFactory() {
        this.addToMap(Integer.TYPE, new IntegerVersionMath());
        this.addToMap(Integer.class, new IntegerVersionMath());
        this.addToMap(Long.TYPE, new LongVersionMath());
        this.addToMap(Long.class, new LongVersionMath());
        this.addToMap(BigDecimal.class, new BigDecimalVersionMath());
    }

    private <K> void addToMap(Class<K> clazz, VersionMath<K> math) {
        this.maths.put(clazz, math);
    }

    public <T> VersionMath<T> getMath(Class<T> clazz, boolean isVersionField) {
        if (!isVersionField) {
            return new NullVersionMath();
        }
        if (this.maths.containsKey(clazz)) {
            return this.maths.get(clazz);
        }
        throw new OrmConfigurationException("Cannot manipulate version for type [" + clazz + "]. Allowed types [" + MapUtil.keysToString(this.maths) + "].");
    }
}

