/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.persistor.type.ext;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;
import java.math.BigDecimal;

public class FloatToBigDecimalWrapper
implements ExtendedTypeWrapper<Float, BigDecimal> {
    @Override
    public Class<BigDecimal> jdbcType() {
        return BigDecimal.class;
    }

    @Override
    public Class<Float> propertyType() {
        return Float.class;
    }

    @Override
    public Float wrap(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return Float.valueOf(value.floatValue());
    }

    @Override
    public BigDecimal unWrap(Float value) {
        if (value == null) {
            return null;
        }
        return BigDecimal.valueOf(value.floatValue());
    }

    @Override
    public Float clone(Float source) {
        return source;
    }
}

