/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.persistor.type.ext;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;
import java.math.BigDecimal;

public class BooleanToBigDecimalWrapper
implements ExtendedTypeWrapper<Boolean, BigDecimal> {
    @Override
    public Class<BigDecimal> jdbcType() {
        return BigDecimal.class;
    }

    @Override
    public Class<Boolean> propertyType() {
        return Boolean.class;
    }

    @Override
    public Boolean wrap(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return !BigDecimal.ZERO.equals(value);
    }

    @Override
    public BigDecimal unWrap(Boolean value) {
        if (value == null) {
            return null;
        }
        if (value.booleanValue()) {
            return BigDecimal.ONE;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public Boolean clone(Boolean source) {
        return source;
    }
}

