/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.persistor.type;

import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;
import com.jpattern.orm.persistor.type.JdbcIO;
import com.jpattern.orm.persistor.type.TypeWrapper;
import com.jpattern.orm.persistor.type.ext.BooleanToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.ByteToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.CharacterToStringWrapper;
import com.jpattern.orm.persistor.type.ext.DoubleToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.FloatToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.IntegerToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.JodaDateMidnightToTimestampWrapper;
import com.jpattern.orm.persistor.type.ext.JodaDateTimeToSqlTimestampWrapper;
import com.jpattern.orm.persistor.type.ext.JodaLocalDateTimeToSqlTimestampWrapper;
import com.jpattern.orm.persistor.type.ext.JodaLocalDateToSqlTimestampWrapper;
import com.jpattern.orm.persistor.type.ext.LongToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.ShortToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.UtilDateToSqlTimestampWrapper;
import com.jpattern.orm.persistor.type.jdbc.ArrayJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.ArrayNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.BigDecimalJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.BigDecimalNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.BlobJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.BlobNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.BooleanPrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.BooleanPrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.BytePrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.BytePrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.BytesJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.BytesNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.ClobJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.ClobNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.DateJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.DateNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.DoublePrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.DoublePrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.FloatPrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.FloatPrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.InputStreamJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.InputStreamNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.IntegerPrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.IntegerPrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.LongPrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.LongPrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.NClobJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.NClobNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.ObjectJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.ObjectNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.ReaderJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.ReaderNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.RefJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.RefNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.RowIdJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.RowIdNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.SQLXMLJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.SQLXMLNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.ShortPrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.ShortPrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.StringJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.StringNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.TimeJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.TimeNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.TimestampJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.TimestampNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.URLJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.URLNullWrapper;
import com.jpattern.orm.util.MapUtil;
import java.util.HashMap;
import java.util.Map;

public class TypeFactory {
    private Map<Class<?>, JdbcIO<?>> jdbcIOs = new HashMap();
    private Map<Class<?>, TypeWrapper<?, ?>> typeWrappers = new HashMap();

    public TypeFactory() {
        this.registerJdbcType();
        this.registerExtendedType();
    }

    public <DB> JdbcIO<DB> getJdbcIO(Class<DB> clazz) {
        if (this.jdbcIOs.containsKey(clazz)) {
            return this.jdbcIOs.get(clazz);
        }
        throw new OrmConfigurationException("Not found getter in ResultSet for type [" + clazz + "]. Allowed types [" + MapUtil.keysToString(this.jdbcIOs) + "].");
    }

    public <P, DB> TypeWrapper<P, DB> getTypeWrapper(Class<P> clazz) {
        if (this.typeWrappers.containsKey(clazz)) {
            return this.typeWrappers.get(clazz);
        }
        throw new OrmConfigurationException("Cannot manipulate properties of type [" + clazz + "]. Allowed types [" + MapUtil.keysToString(this.typeWrappers) + "]. Use another type or register a custom " + TypeWrapper.class.getName());
    }

    private void registerJdbcType() {
        this.addType(new ArrayJdbcIO(), new ArrayNullWrapper());
        this.addType(new BigDecimalJdbcIO(), new BigDecimalNullWrapper());
        this.addType(new BlobJdbcIO(), new BlobNullWrapper());
        this.addType(new BooleanPrimitiveJdbcIO(), new BooleanPrimitiveNullWrapper());
        this.addType(new BytesJdbcIO(), new BytesNullWrapper());
        this.addType(new BytePrimitiveJdbcIO(), new BytePrimitiveNullWrapper());
        this.addType(new ClobJdbcIO(), new ClobNullWrapper());
        this.addType(new DateJdbcIO(), new DateNullWrapper());
        this.addType(new DoublePrimitiveJdbcIO(), new DoublePrimitiveNullWrapper());
        this.addType(new FloatPrimitiveJdbcIO(), new FloatPrimitiveNullWrapper());
        this.addType(new InputStreamJdbcIO(), new InputStreamNullWrapper());
        this.addType(new IntegerPrimitiveJdbcIO(), new IntegerPrimitiveNullWrapper());
        this.addType(new LongPrimitiveJdbcIO(), new LongPrimitiveNullWrapper());
        this.addType(new NClobJdbcIO(), new NClobNullWrapper());
        this.addType(new ObjectJdbcIO(), new ObjectNullWrapper());
        this.addType(new ReaderJdbcIO(), new ReaderNullWrapper());
        this.addType(new RefJdbcIO(), new RefNullWrapper());
        this.addType(new RowIdJdbcIO(), new RowIdNullWrapper());
        this.addType(new ShortPrimitiveJdbcIO(), new ShortPrimitiveNullWrapper());
        this.addType(new SQLXMLJdbcIO(), new SQLXMLNullWrapper());
        this.addType(new StringJdbcIO(), new StringNullWrapper());
        this.addType(new TimeJdbcIO(), new TimeNullWrapper());
        this.addType(new TimestampJdbcIO(), new TimestampNullWrapper());
        this.addType(new URLJdbcIO(), new URLNullWrapper());
    }

    private void registerExtendedType() {
        this.addTypeWrapper(new BooleanToBigDecimalWrapper());
        this.addTypeWrapper(new ByteToBigDecimalWrapper());
        this.addTypeWrapper(new CharacterToStringWrapper());
        this.addTypeWrapper(new DoubleToBigDecimalWrapper());
        this.addTypeWrapper(new FloatToBigDecimalWrapper());
        this.addTypeWrapper(new IntegerToBigDecimalWrapper());
        this.addTypeWrapper(new LongToBigDecimalWrapper());
        this.addTypeWrapper(new ShortToBigDecimalWrapper());
        this.addTypeWrapper(new UtilDateToSqlTimestampWrapper());
        try {
            this.addTypeWrapper(new JodaDateTimeToSqlTimestampWrapper());
            this.addTypeWrapper(new JodaDateMidnightToTimestampWrapper());
            this.addTypeWrapper(new JodaLocalDateTimeToSqlTimestampWrapper());
            this.addTypeWrapper(new JodaLocalDateToSqlTimestampWrapper());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private <DB> void addType(JdbcIO<DB> jdbcIO, TypeWrapper<DB, DB> typeWrapper) {
        this.typeWrappers.put(typeWrapper.propertyType(), typeWrapper);
        this.jdbcIOs.put(jdbcIO.getDBClass(), jdbcIO);
    }

    public void addTypeWrapper(ExtendedTypeWrapper<?, ?> typeWrapper) {
        if (!this.jdbcIOs.containsKey(typeWrapper.jdbcType())) {
            throw new OrmConfigurationException("Cannot register TypeWrapper " + typeWrapper.getClass() + ". The specified jdbc type " + typeWrapper.jdbcType() + " is not a valid type for the ResultSet and PreparedStatement getters/setters");
        }
        this.typeWrappers.put(typeWrapper.propertyType(), typeWrapper);
    }
}

