/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.persistor.reflection;

import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.persistor.reflection.SetManipulator;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class FieldSetManipulator<BEAN, P>
extends SetManipulator<BEAN, P> {
    private final Field field;

    public FieldSetManipulator(Field field) {
        this.field = field;
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            throw new OrmConfigurationException("Field [" + field.getName() + "] of class [" + field.getDeclaringClass() + "] is marked FINAL. His value cannot be managed by JPOrm. Please remove the 'final' modifier.");
        }
    }

    @Override
    public void setValue(BEAN bean, P value) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(bean, value);
    }
}

