/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.persistor.generator;

import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.persistor.generator.BigDecimalValueChecker;
import com.jpattern.orm.persistor.generator.ByteValueChecker;
import com.jpattern.orm.persistor.generator.IntegerValueChecker;
import com.jpattern.orm.persistor.generator.LongValueChecker;
import com.jpattern.orm.persistor.generator.ShortValueChecker;
import com.jpattern.orm.persistor.generator.ValueChecker;
import com.jpattern.orm.util.MapUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class ValueCheckerFactory {
    private static Map<Class<?>, ValueChecker<?>> VALUE_CHECKERS = new HashMap();

    private ValueCheckerFactory() {
    }

    private static <P> void addValueChecker(Class<P> clazz, ValueChecker<P> valueChecker) {
        VALUE_CHECKERS.put(clazz, valueChecker);
    }

    public static <P> ValueChecker<P> getValueChecker(Class<P> clazz) {
        if (VALUE_CHECKERS.containsKey(clazz)) {
            return VALUE_CHECKERS.get(clazz);
        }
        throw new OrmConfigurationException("Cannot use type " + clazz + " for a field annotated as Generated. Valid classes are [" + MapUtil.keysToString(VALUE_CHECKERS) + "]");
    }

    static {
        ValueCheckerFactory.addValueChecker(BigDecimal.class, new BigDecimalValueChecker());
        ValueCheckerFactory.addValueChecker(Byte.class, new ByteValueChecker());
        ValueCheckerFactory.addValueChecker(Byte.TYPE, new ByteValueChecker());
        ValueCheckerFactory.addValueChecker(Integer.class, new IntegerValueChecker());
        ValueCheckerFactory.addValueChecker(Integer.TYPE, new IntegerValueChecker());
        ValueCheckerFactory.addValueChecker(Long.class, new LongValueChecker());
        ValueCheckerFactory.addValueChecker(Long.TYPE, new LongValueChecker());
        ValueCheckerFactory.addValueChecker(Short.class, new ShortValueChecker());
        ValueCheckerFactory.addValueChecker(Short.TYPE, new ShortValueChecker());
    }
}

