/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.orm.persistor.generator;

import com.jpattern.orm.persistor.PropertyPersistor;
import com.jpattern.orm.persistor.generator.GeneratorManipulator;
import com.jpattern.orm.persistor.generator.ValueChecker;
import java.lang.reflect.InvocationTargetException;

public class GeneratorManipulatorImpl<BEAN, P>
extends GeneratorManipulator<BEAN> {
    private final long[] validValues;
    private final PropertyPersistor<BEAN, P, ?> fieldManipulator;
    private ValueChecker<P> valueChecker;

    public GeneratorManipulatorImpl(PropertyPersistor<BEAN, P, ?> fieldManipulator, ValueChecker<P> valueChecker, long[] validValues) throws SecurityException, NoSuchMethodException {
        this.valueChecker = valueChecker;
        this.fieldManipulator = fieldManipulator;
        this.validValues = validValues;
    }

    @Override
    public boolean useGenerator(BEAN bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this.valueChecker.useGenerator(this.validValues, this.fieldManipulator.getPropertyValueFromBean(bean));
    }

    @Override
    public boolean hasConditionalGenerator() {
        return this.validValues.length != 0;
    }

    @Override
    public boolean hasGenerator() {
        return true;
    }
}

